/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalDeleteFeature;
import ch.cyberduck.core.nio.LocalDirectoryFeature;
import ch.cyberduck.core.nio.LocalFindFeature;
import ch.cyberduck.core.nio.LocalHomeFinderFeature;
import ch.cyberduck.core.nio.LocalListService;
import ch.cyberduck.core.nio.LocalMoveFeature;
import ch.cyberduck.core.nio.LocalReadFeature;
import ch.cyberduck.core.nio.LocalSymlinkFeature;
import ch.cyberduck.core.nio.LocalTouchFeature;
import ch.cyberduck.core.nio.LocalUnixPermissionFeature;
import ch.cyberduck.core.nio.LocalWriteFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.apache.log4j.Logger;

public class LocalSession
extends Session<FileSystem> {
    private static final Logger log = Logger.getLogger(LocalSession.class);
    private Object lock;

    protected LocalSession(Host h) {
        super(h);
    }

    public LocalSession(Host h, X509TrustManager trust, X509KeyManager key) {
        super(h);
    }

    protected FileSystem connect(HostKeyCallback key) throws BackgroundException {
        return FileSystems.getDefault();
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return new LocalListService(this).list(directory, listener);
    }

    public void login(HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel, Cache cache) throws BackgroundException {
        Path home = new LocalHomeFinderFeature(this).find();
        try {
            this.lock = LocalFactory.get((String)home.getAbsolute()).lock(true);
        }
        catch (LocalAccessDeniedException e) {
            log.debug((Object)String.format("Ignore failure obtaining lock for %s", home));
        }
    }

    protected void logout() throws BackgroundException {
        Path home = new LocalHomeFinderFeature(this).find();
        LocalFactory.get((String)home.getAbsolute()).release(this.lock);
    }

    protected boolean isPosixFilesystem() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Touch.class) {
            return (T)new LocalTouchFeature(this);
        }
        if (type == Find.class) {
            return (T)new LocalFindFeature(this);
        }
        if (type == Attributes.class) {
            return (T)new LocalAttributesFinderFeature(this);
        }
        if (type == Read.class) {
            return (T)new LocalReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new LocalWriteFeature(this));
        }
        if (type == Delete.class) {
            return (T)new LocalDeleteFeature(this);
        }
        if (type == Move.class) {
            return (T)new LocalMoveFeature(this);
        }
        if (type == Directory.class) {
            return (T)new LocalDirectoryFeature(this);
        }
        if (type == Symlink.class && this.isPosixFilesystem()) {
            return (T)new LocalSymlinkFeature(this);
        }
        if (type == UnixPermission.class && this.isPosixFilesystem()) {
            return (T)((Object)new LocalUnixPermissionFeature(this));
        }
        if (type == Home.class) {
            return (T)((Object)new LocalHomeFinderFeature(this));
        }
        return (T)super._getFeature(type);
    }
}

