/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class LocalSymlinkFeature
implements Symlink {
    private final LocalSession session;

    public LocalSymlinkFeature(LocalSession session) {
        this.session = session;
    }

    public void symlink(Path file, String target) throws BackgroundException {
        try {
            Files.createSymbolicLink(((FileSystem)this.session.getClient()).getPath(file.getAbsolute(), new String[0]), ((FileSystem)this.session.getClient()).getPath(target, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Cannot create file {0}", e, file);
        }
    }
}

