/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.util.EnumSet;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveDrivesIterator;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveContainerListService
implements RootListService {
    private final OneDriveSession session;

    public OneDriveContainerListService(OneDriveSession session) {
        this.session = session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        try {
            OneDriveDrivesIterator iter = new OneDriveDrivesIterator((OneDriveAPI)this.session.getClient());
            while (iter.hasNext()) {
                try {
                    OneDriveDrive.Metadata metadata = iter.next();
                    PathAttributes attributes = new PathAttributes();
                    attributes.setSize(metadata.getTotal().longValue());
                    children.add((Referenceable)new Path(directory, metadata.getId(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes));
                    listener.chunk(directory, children);
                }
                catch (OneDriveRuntimeException e) {
                    throw new OneDriveExceptionMappingService().map(e.getCause());
                    return children;
                }
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveExceptionMappingService().map("Listing directory {0} failed", e.getCause(), directory);
        }
    }
}

