/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class OneDriveDirectoryFeature
implements Directory {
    private final OneDriveSession session;

    public OneDriveDirectoryFeature(OneDriveSession session) {
        this.session = session;
    }

    public Path mkdir(Path directory, String region, TransferStatus status) throws BackgroundException {
        try {
            this.session.toFolder(directory.getParent()).create(directory.getName());
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot create folder {0}", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, directory);
        }
        return directory;
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public Directory withWriter(Write writer) {
        return this;
    }
}

