/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveItemListService
implements ListService {
    private static final Logger log = Logger.getLogger(OneDriveItemListService.class);
    private final PathContainerService containerService = new PathContainerService();
    private final OneDriveSession session;
    private final OneDriveAttributesFinderFeature attributes;

    public OneDriveItemListService(OneDriveSession session) {
        this.session = session;
        this.attributes = new OneDriveAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        try {
            OneDriveDrive drive = new OneDriveDrive((OneDriveAPI)this.session.getClient(), this.containerService.getContainer(directory).getName());
            OneDriveFolder folder = this.containerService.isContainer(directory) ? drive.getRoot() : new OneDriveFolder((OneDriveAPI)this.session.getClient(), drive, this.containerService.getKey(directory));
            Iterator iterator = folder.iterator();
            while (iterator.hasNext()) {
                OneDriveItem.Metadata metadata;
                try {
                    metadata = (OneDriveItem.Metadata)iterator.next();
                }
                catch (OneDriveRuntimeException e) {
                    log.warn((Object)e);
                    continue;
                }
                PathAttributes attributes = this.attributes.convert(metadata);
                children.add((Referenceable)new Path(directory, metadata.getName(), metadata.isFolder() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), attributes));
                listener.chunk(directory, children);
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveExceptionMappingService().map("Listing directory {0} failed", e.getCause(), directory);
        }
        return children;
    }
}

