/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveContainerListService;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveItemListService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveListService
implements ListService {
    private final OneDriveSession session;

    public OneDriveListService(OneDriveSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            if (directory.isRoot()) {
                return new OneDriveContainerListService(this.session).list(directory, listener);
            }
            return new OneDriveItemListService(this.session).list(directory, listener);
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveExceptionMappingService().map("Listing directory {0} failed", e.getCause(), directory);
        }
    }
}

