/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.io.IOException;
import org.apache.commons.codec.binary.StringUtils;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDrivePatchOperation;

public class OneDriveMoveFeature
implements Move {
    private final OneDriveSession session;
    private final PathContainerService containerService = new PathContainerService();

    public OneDriveMoveFeature(OneDriveSession session) {
        this.session = session;
    }

    public void move(Path file, Path renamed, boolean exists, Delete.Callback callback) throws BackgroundException {
        OneDrivePatchOperation patchOperation = new OneDrivePatchOperation();
        if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)renamed.getName())) {
            patchOperation.rename(renamed.getName());
        }
        if (!file.getParent().equals((Object)renamed.getParent())) {
            patchOperation.move(this.session.toFolder(renamed.getParent()));
        }
        try {
            this.session.toFile(file).patch(patchOperation);
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot rename {0}", (Throwable)e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source)) {
            return false;
        }
        return this.containerService.getContainer(source).equals((Object)this.containerService.getContainer(target));
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

