/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.preferences.PreferencesFactory;

public class OneDriveProtocol
extends AbstractProtocol {
    public String getIdentifier() {
        return "onedrive";
    }

    public String getDescription() {
        return "Microsoft OneDrive";
    }

    public String getName() {
        return "OneDrive";
    }

    public String getPrefix() {
        return String.format("%s.%s", OneDriveProtocol.class.getPackage().getName(), "OneDrive");
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public boolean isAnonymousConfigurable() {
        return false;
    }

    public boolean isUsernameConfigurable() {
        return true;
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Authorization code", (String)"Credentials");
    }

    public boolean isPasswordConfigurable() {
        return false;
    }

    public String getClientId() {
        return PreferencesFactory.get().getProperty("onedrive.oauth.clientid");
    }

    public String getClientSecret() {
        return PreferencesFactory.get().getProperty("onedrive.oauth.secret");
    }

    public boolean isEnabled() {
        return false;
    }
}

