/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveHomeFinderFeature;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;

public class OneDriveQuotaFeature
implements Quota {
    private final OneDriveSession session;

    public OneDriveQuotaFeature(OneDriveSession session) {
        this.session = session;
    }

    public Quota.Space get() throws BackgroundException {
        OneDriveDrive.Metadata metadata;
        OneDriveDrive drive = new OneDriveDrive((OneDriveAPI)this.session.getClient(), new OneDriveHomeFinderFeature(this.session).find().getName());
        try {
            metadata = drive.getMetadata(new OneDriveExpand[0]);
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot get space {0}", e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot get space {0}", (Throwable)e);
        }
        return new Quota.Space(metadata.getUsed(), metadata.getTotal());
    }
}

