/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class OneDriveReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(OneDriveReadFeature.class);
    private final OneDriveSession session;

    public OneDriveReadFeature(OneDriveSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("%d-", range.getStart()) : String.format("%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add range header %s for file %s", header, file));
                }
                return this.session.toFile(file).download(header);
            }
            return this.session.toFile(file).download();
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) throws BackgroundException {
        return true;
    }
}

