/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.io.IOException;
import java.net.URI;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveSharingLink;

public class OneDriveSharingLinkUrlProvider
implements UrlProvider {
    private static final Logger log = Logger.getLogger(OneDriveSharingLinkUrlProvider.class);
    private final OneDriveSession session;

    public OneDriveSharingLinkUrlProvider(OneDriveSession session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        try {
            DescriptiveUrlBag list = new DescriptiveUrlBag();
            list.add(new DescriptiveUrl(URI.create(this.session.toFile(file).createSharedLink(OneDriveSharingLink.Type.VIEW).getLink().getWebUrl()), DescriptiveUrl.Type.signed));
            return list;
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure creating shared link. %s", e.getMessage()));
            return DescriptiveUrlBag.empty();
        }
    }
}

