/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.SegmentingOutputStream;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveUploadSession;

public class OneDriveWriteFeature
implements MultipartWrite<Void> {
    private final Preferences preferences = PreferencesFactory.get();
    private final OneDriveSession session;
    private final Find finder;
    private final AttributesFinder attributes;

    public OneDriveWriteFeature(OneDriveSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public OneDriveWriteFeature(OneDriveSession session, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<Void> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            OneDriveUploadSession upload = this.session.toFile(file).createUploadSession();
            ChunkedOutputStream proxy = new ChunkedOutputStream(upload, status.getOffset() + status.getLength());
            return new HttpResponseOutputStream<Void>((OutputStream)new SegmentingOutputStream((OutputStream)proxy, this.preferences.getInteger("onedrive.upload.multipart.partsize.minimum"))){

                public Void getStatus() throws BackgroundException {
                    return null;
                }
            };
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum() {
        return new DisabledChecksumCompute();
    }

    private final class ChunkedOutputStream
    extends OutputStream {
        private final OneDriveUploadSession upload;
        private final Long length;
        private Long offset = 0L;

        public ChunkedOutputStream(OneDriveUploadSession upload, Long length) {
            this.upload = upload;
            this.length = length;
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] content = Arrays.copyOfRange(b, off, len);
            HttpRange range = HttpRange.byLength((long)this.offset, (long)content.length);
            String header = this.length == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), this.length);
            this.upload.uploadFragment(header, content);
            this.offset = this.offset + (long)content.length;
        }
    }
}

