/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Container;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftContainerListService
implements RootListService {
    private static final Logger log = Logger.getLogger(SwiftContainerListService.class);
    private final SwiftSession session;
    private final Preferences preferences = PreferencesFactory.get();
    private final boolean cdnPreload;
    private final boolean containerPreload;
    private final SwiftLocationFeature.SwiftRegion region;

    public SwiftContainerListService(SwiftSession session, SwiftRegionService regionService, SwiftLocationFeature.SwiftRegion region) {
        this(session, regionService, region, PreferencesFactory.get().getBoolean("openstack.cdn.preload"), PreferencesFactory.get().getBoolean("openstack.container.size.preload"));
    }

    public SwiftContainerListService(SwiftSession session, SwiftRegionService regionService, SwiftLocationFeature.SwiftRegion region, boolean cdnPreload, boolean containerPreload) {
        this.session = session;
        this.region = region;
        this.cdnPreload = cdnPreload;
        this.containerPreload = containerPreload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("List containers for %s", new Object[]{this.session}));
        }
        try {
            AttributedList containers = new AttributedList();
            int limit = this.preferences.getInteger("openstack.list.container.limit");
            final Client client = (Client)this.session.getClient();
            for (final Region r : client.getRegions()) {
                List chunk;
                if (this.region.getIdentifier() != null && !StringUtils.equals((CharSequence)r.getRegionId(), (CharSequence)this.region.getIdentifier())) {
                    log.warn((Object)String.format("Skip region %s", r));
                    continue;
                }
                String marker = null;
                do {
                    chunk = client.listContainers(r, limit, marker);
                    for (Container f : chunk) {
                        PathAttributes attributes = new PathAttributes();
                        attributes.setRegion(f.getRegion().getRegionId());
                        containers.add((Referenceable)new Path(String.format("/%s", f.getName()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory), attributes));
                        marker = f.getName();
                    }
                    listener.chunk(directory, containers);
                } while (!chunk.isEmpty());
                if (this.cdnPreload) {
                    final DistributionConfiguration feature = (DistributionConfiguration)this.session.getFeature(DistributionConfiguration.class);
                    DefaultThreadPool pool = new DefaultThreadPool("cdn", 2);
                    try {
                        for (final Path container : containers) {
                            pool.execute((Callable)new Callable<Void>(){

                                @Override
                                public Void call() {
                                    for (Distribution.Method method : feature.getMethods(container)) {
                                        try {
                                            Distribution distribution = feature.read(container, method, (LoginCallback)new DisabledLoginCallback());
                                            if (!log.isInfoEnabled()) continue;
                                            log.info((Object)String.format("Cached distribution %s", distribution));
                                        }
                                        catch (BackgroundException e) {
                                            log.warn((Object)String.format("Failure caching CDN configuration for container %s %s", container, e.getMessage()));
                                        }
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    finally {
                        pool.shutdown(true);
                    }
                }
                if (!this.containerPreload) continue;
                DefaultThreadPool pool = new DefaultThreadPool("container", 2);
                try {
                    for (final Path container : containers) {
                        pool.execute((Callable)new Callable<Long>(){

                            @Override
                            public Long call() throws IOException {
                                long size = client.getContainerInfo(r, container.getName()).getTotalSize();
                                container.attributes().setSize(size);
                                return size;
                            }
                        });
                    }
                }
                finally {
                    pool.shutdown(true);
                }
            }
            return containers;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

