/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.io.OutputStream;

public class SwiftDirectoryFeature
implements Directory<StorageObject> {
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private Write<StorageObject> writer;

    public SwiftDirectoryFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftDirectoryFeature(SwiftSession session, SwiftRegionService regionService) {
        this(session, regionService, new SwiftWriteFeature(session, regionService));
    }

    public SwiftDirectoryFeature(SwiftSession session, SwiftRegionService regionService, Write<StorageObject> writer) {
        this.session = session;
        this.regionService = regionService;
        this.writer = writer;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                ((Client)this.session.getClient()).createContainer(this.regionService.lookup(new SwiftLocationFeature.SwiftRegion(region)), folder.getName());
            } else {
                status.setMime("application/directory");
                status.setLength(0L);
                new DefaultStreamCloser().close((OutputStream)this.writer.write(folder, status, (ConnectionCallback)new DisabledConnectionCallback()));
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, folder);
        }
        return folder;
    }

    public boolean isSupported(Path workdir) {
        return true;
    }

    public SwiftDirectoryFeature withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

