/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.openstack.SwiftMetadataFeature;
import ch.cyberduck.core.openstack.SwiftSession;

public class SwiftFindFeature
implements Find {
    private final Headers feature;
    private Cache<Path> cache;

    public SwiftFindFeature(SwiftSession session) {
        this(new SwiftMetadataFeature(session));
    }

    public SwiftFindFeature(Headers feature) {
        this.feature = feature;
        this.cache = PathCache.empty();
    }

    public boolean find(Path file) throws BackgroundException {
        AttributedList list;
        if (file.isRoot()) {
            return true;
        }
        if (this.cache.isCached((Referenceable)file.getParent())) {
            list = this.cache.get((Referenceable)file.getParent());
        } else {
            list = new AttributedList();
            this.cache.put((Referenceable)file.getParent(), list);
        }
        if (list.contains((Referenceable)file)) {
            return true;
        }
        if (this.cache.isHidden((Referenceable)file)) {
            return false;
        }
        try {
            this.feature.getMetadata(file);
            list.add((Referenceable)file);
            return true;
        }
        catch (NotfoundException e) {
            list.attributes().addHidden((Object)file);
            return false;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

