/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.openstack.SwiftCopyFeature;
import ch.cyberduck.core.openstack.SwiftDeleteFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.log4j.Logger;

public class SwiftMoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(SwiftMoveFeature.class);
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private Delete delete;

    public SwiftMoveFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftMoveFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
        this.delete = new SwiftDeleteFeature(session);
    }

    public void move(Path source, Path renamed, boolean exists, Delete.Callback callback) throws BackgroundException {
        if (source.isFile()) {
            new SwiftCopyFeature(this.session, this.regionService).copy(source, renamed, new TransferStatus());
            this.delete.delete(Collections.singletonList(source), (LoginCallback)new DisabledLoginCallback(), callback);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

