/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.io.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class SwiftReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(SwiftReadFeature.class);
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftReadFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            HttpRange range;
            status.setChecksum(Checksum.NONE);
            ContentLengthInputStream stream = status.isAppend() ? (-1L == (range = HttpRange.withStatus((TransferStatus)status)).getEnd() ? ((Client)this.session.getClient()).getObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), range.getStart()) : ((Client)this.session.getClient()).getObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), range.getStart(), range.getLength())) : ((Client)this.session.getClient()).getObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reading stream with content length %d", stream.getLength()));
            }
            return stream;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }

    public boolean offset(Path file) {
        return true;
    }
}

