/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.openstack.SwiftLargeObjectUploadFeature;
import ch.cyberduck.core.openstack.SwiftMultipleDeleteFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftSmallObjectUploadFeature;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.model.StorageObject;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SwiftThresholdUploadService
implements Upload<StorageObject> {
    private static final Logger log = Logger.getLogger(SwiftThresholdUploadService.class);
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private final Long threshold;
    private final Preferences preferences = PreferencesFactory.get();
    private Write<StorageObject> writer;

    public SwiftThresholdUploadService(SwiftSession session, SwiftRegionService regionService, SwiftWriteFeature writer) {
        this(session, regionService, writer, PreferencesFactory.get().getLong("openstack.upload.largeobject.threshold"));
    }

    public SwiftThresholdUploadService(SwiftSession session, SwiftRegionService regionService, SwiftWriteFeature writer, Long threshold) {
        this.session = session;
        this.regionService = regionService;
        this.writer = writer;
        this.threshold = threshold;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return this.writer.append(file, length, cache);
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        HttpUploadFeature feature;
        if (status.getLength() > this.threshold) {
            if (!this.preferences.getBoolean("openstack.upload.largeobject") && status.getLength() < this.preferences.getLong("openstack.upload.largeobject.required.threshold")) {
                log.warn((Object)"Large upload is disabled with property openstack.upload.largeobject");
                return (StorageObject)new SwiftSmallObjectUploadFeature(this.writer).upload(file, local, throttle, listener, status, callback);
            }
            feature = new SwiftLargeObjectUploadFeature(this.session, this.regionService, this.writer, this.preferences.getLong("openstack.upload.largeobject.size"), this.preferences.getInteger("openstack.upload.largeobject.concurrency"));
        } else {
            feature = new SwiftSmallObjectUploadFeature(this.writer);
        }
        ArrayList<Path> segments = new ArrayList<Path>();
        if (this.preferences.getBoolean("openstack.upload.largeobject.cleanup") && !status.isAppend() && !status.isRetry()) {
            segments.addAll(new SwiftSegmentService(this.session, this.regionService).list(file));
        }
        StorageObject checksum = (StorageObject)feature.upload(file, local, throttle, listener, status, callback);
        if (!segments.isEmpty()) {
            new SwiftMultipleDeleteFeature(this.session).delete(segments, (LoginCallback)new DisabledLoginCallback(), (Delete.Callback)new Delete.DisabledCallback());
        }
        return checksum;
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

