/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.DisabledSheetCallback;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.controller.InsecureLoginAlertController;
import ch.cyberduck.ui.cocoa.controller.LoginController;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public final class PromptLoginCallback
implements LoginCallback {
    private static final Logger log = Logger.getLogger(PromptLoginCallback.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final WindowController parent;
    private NSOpenPanel select;

    public PromptLoginCallback(WindowController parent) {
        this.parent = parent;
    }

    public void warn(Protocol protocol, String title, String message, String continueButton, String disconnectButton, String preference) throws LoginCanceledException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Display insecure connection alert for %s", protocol));
        }
        InsecureLoginAlertController alert = new InsecureLoginAlertController(title, message, continueButton, disconnectButton, protocol);
        int option = alert.beginSheet(this.parent);
        if (alert.isSuppressed()) {
            this.preferences.setProperty(preference, true);
        }
        switch (option) {
            case -1: {
                throw new LoginCanceledException();
            }
        }
    }

    public void prompt(Host bookmark, Credentials credentials, String title, String reason, LoginOptions options) throws LoginCanceledException {
        LoginController controller;
        SheetInvoker sheet;
        int option;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Prompt for credentials for %s", bookmark));
        }
        if ((option = (sheet = new SheetInvoker((SheetCallback)(controller = new LoginController(title, reason, bookmark, credentials, options)), this.parent, (WindowController)controller)).beginSheet()) == -1) {
            throw new LoginCanceledException();
        }
    }

    public Local select(Local identity) throws LoginCanceledException {
        NSObject selected;
        SheetInvoker sheet = new SheetInvoker((SheetCallback)new DisabledSheetCallback(), this.parent, (NSWindow)this.select){

            public int beginSheet(NSWindow window) {
                PromptLoginCallback.this.select = NSOpenPanel.openPanel();
                PromptLoginCallback.this.select.setCanChooseDirectories(false);
                PromptLoginCallback.this.select.setCanChooseFiles(true);
                PromptLoginCallback.this.select.setAllowsMultipleSelection(false);
                PromptLoginCallback.this.select.setMessage(LocaleFactory.localizedString((String)"Select the private key in PEM or PuTTY format", (String)"Credentials"));
                PromptLoginCallback.this.select.setPrompt(LocaleFactory.localizedString((String)"Choose"));
                PromptLoginCallback.this.select.beginSheetForDirectory(LocalFactory.get((String)"~/.ssh").getAbsolute(), null, PromptLoginCallback.this.parent.window(), this.id(), Foundation.selector((String)"sheetDidClose:returnCode:contextInfo:"), null);
                return this.getSelectedOption();
            }
        };
        int option = sheet.beginSheet();
        if (option == 1 && (selected = this.select.filenames().lastObject()) != null) {
            return LocalFactory.get((String)selected.toString());
        }
        throw new LoginCanceledException();
    }
}

