/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.Path;
import ch.cyberduck.ui.browser.Column;
import ch.cyberduck.ui.browser.PathTooltipService;
import ch.cyberduck.ui.comparator.ExtensionComparator;
import ch.cyberduck.ui.comparator.FileTypeComparator;
import ch.cyberduck.ui.comparator.FilenameComparator;
import ch.cyberduck.ui.comparator.GroupComparator;
import ch.cyberduck.ui.comparator.OwnerComparator;
import ch.cyberduck.ui.comparator.PermissionsComparator;
import ch.cyberduck.ui.comparator.RegionComparator;
import ch.cyberduck.ui.comparator.SizeComparator;
import ch.cyberduck.ui.comparator.TimestampComparator;
import ch.cyberduck.ui.comparator.VersionComparator;
import java.util.Comparator;
import org.apache.log4j.Logger;

public abstract class AbstractPathTableDelegate
extends AbstractTableDelegate<Path> {
    private static final Logger log = Logger.getLogger(AbstractTableDelegate.class);
    private final PathTooltipService tooltip = new PathTooltipService();

    protected AbstractPathTableDelegate(NSTableColumn selectedColumn) {
        super(selectedColumn);
    }

    public String tooltip(Path file) {
        return this.tooltip.getTooltip(file);
    }

    public Comparator<Path> getSortingComparator() {
        boolean ascending = this.isSortedAscending();
        String identifier = this.selectedColumnIdentifier();
        switch (Column.valueOf((String)identifier)) {
            case icon: 
            case kind: {
                return new FileTypeComparator(ascending);
            }
            case extension: {
                return new ExtensionComparator(ascending);
            }
            case filename: {
                return new FilenameComparator(ascending);
            }
            case size: {
                return new SizeComparator(ascending);
            }
            case modified: {
                return new TimestampComparator(ascending);
            }
            case owner: {
                return new OwnerComparator(ascending);
            }
            case group: {
                return new GroupComparator(ascending);
            }
            case permission: {
                return new PermissionsComparator(ascending);
            }
            case region: {
                return new RegionComparator(ascending);
            }
            case version: {
                return new VersionComparator(ascending);
            }
        }
        log.error((Object)String.format("Unknown column identifier %s", identifier));
        return new NullComparator();
    }
}

