/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.HyperlinkAttributedStringFactory;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.diagnostics.ReachabilityFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.sftp.openssh.OpenSSHPrivateKeyConfigurator;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.ui.InputValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSSize;

public class BookmarkController
extends SheetController
implements CollectionListener {
    private static final Logger log = Logger.getLogger(BookmarkController.class);
    private static NSPoint cascade = new NSPoint(0.0, 0.0);
    protected final Preferences preferences = PreferencesFactory.get();
    protected final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final List<BookmarkObserver> observers = new ArrayList<BookmarkObserver>();
    protected final Host bookmark;
    protected final Credentials credentials;
    protected final LoginOptions options;
    protected NSPopUpButton protocolPopup;
    protected NSTextField hostField;
    protected NSButton alertIcon;
    protected NSTextField portField;
    protected NSTextField pathField;
    protected NSTextField urlField;
    protected NSTextField usernameField;
    protected NSTextField usernameLabel;
    protected NSButton anonymousCheckbox;
    protected NSPopUpButton privateKeyPopup;
    protected NSOpenPanel privateKeyOpenPanel;

    public BookmarkController(Host bookmark) {
        this(bookmark, bookmark.getCredentials());
    }

    public BookmarkController(Host bookmark, Credentials credentials) {
        this(bookmark, credentials, new InputValidator(){

            public boolean validate() {
                return true;
            }
        }, new LoginOptions(bookmark.getProtocol()));
    }

    public BookmarkController(Host bookmark, Credentials credentials, InputValidator validator, LoginOptions options) {
        super(validator);
        this.bookmark = bookmark;
        this.credentials = credentials;
        this.options = options;
    }

    public Host getBookmark() {
        return this.bookmark;
    }

    public void setProtocolPopup(NSPopUpButton button) {
        this.protocolPopup = button;
        this.protocolPopup.setEnabled(true);
        this.protocolPopup.setTarget(this.id());
        this.protocolPopup.setAction(Foundation.selector((String)"protocolSelectionChanged:"));
        this.protocolPopup.removeAllItems();
        for (Protocol protocol : ProtocolFactory.getEnabledProtocols()) {
            String title = protocol.getDescription();
            this.protocolPopup.addItemWithTitle(title);
            this.protocolPopup.lastItem().setRepresentedObject(String.valueOf(protocol.hashCode()));
            this.protocolPopup.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed(protocol.icon(), Integer.valueOf(16)));
        }
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.protocolPopup.selectItemAtIndex(BookmarkController.this.protocolPopup.indexOfItemWithRepresentedObject(String.valueOf(bookmark.getProtocol().hashCode())));
            }
        });
    }

    public void protocolSelectionChanged(NSPopUpButton sender) {
        Protocol selected = ProtocolFactory.forName((String)sender.selectedItem().representedObject());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Protocol selection changed to %s", selected));
        }
        this.bookmark.setPort(selected.getDefaultPort());
        if (!this.bookmark.getProtocol().isHostnameConfigurable()) {
            this.bookmark.setHostname(selected.getDefaultHostname());
        }
        if (!selected.isHostnameConfigurable()) {
            this.bookmark.setHostname(selected.getDefaultHostname());
        }
        if (StringUtils.isNotBlank((CharSequence)selected.getDefaultHostname())) {
            this.bookmark.setHostname(selected.getDefaultHostname());
        }
        this.bookmark.setProtocol(selected);
        this.options.configure(selected);
        this.update();
    }

    public void setHostField(NSTextField field) {
        this.hostField = field;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"hostFieldDidChange:"), "NSControlTextDidChangeNotification", (NSObject)field);
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.updateField(BookmarkController.this.hostField, bookmark.getHostname());
                BookmarkController.this.hostField.setEnabled(bookmark.getProtocol().isHostnameConfigurable());
                BookmarkController.this.hostField.cell().setPlaceholderString(bookmark.getProtocol().getDefaultHostname());
            }
        });
    }

    public void hostFieldDidChange(NSNotification sender) {
        String input = this.hostField.stringValue();
        if (Scheme.isURL((String)input)) {
            Host parsed = HostParser.parse((String)input);
            this.bookmark.setHostname(parsed.getHostname());
            this.bookmark.setProtocol(parsed.getProtocol());
            this.bookmark.setPort(parsed.getPort());
            this.bookmark.setDefaultPath(parsed.getDefaultPath());
        } else {
            this.bookmark.setHostname(input);
        }
        this.update();
    }

    public void setAlertIcon(NSButton button) {
        this.alertIcon = button;
        this.alertIcon.setEnabled(false);
        this.alertIcon.setImage(null);
        this.alertIcon.setTarget(this.id());
        this.alertIcon.setAction(Foundation.selector((String)"launchNetworkAssistant:"));
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(final Host bookmark) {
                if (StringUtils.isNotBlank((CharSequence)bookmark.getHostname())) {
                    BookmarkController.this.background((BackgroundAction)new AbstractBackgroundAction<Boolean>(){
                        boolean reachable = false;

                        public Boolean run() throws BackgroundException {
                            this.reachable = ReachabilityFactory.get().isReachable(bookmark);
                            return this.reachable;
                        }

                        public void cleanup() {
                            BookmarkController.this.alertIcon.setEnabled(!this.reachable);
                            BookmarkController.this.alertIcon.setImage(this.reachable ? null : (NSImage)IconCacheFactory.get().iconNamed("alert.tiff"));
                        }
                    });
                } else {
                    BookmarkController.this.alertIcon.setImage((NSImage)IconCacheFactory.get().iconNamed("alert.tiff"));
                    BookmarkController.this.alertIcon.setEnabled(false);
                }
            }
        });
    }

    public void launchNetworkAssistant(NSButton sender) {
        ReachabilityFactory.get().diagnose(this.bookmark);
    }

    public void setPortField(NSTextField field) {
        this.portField = field;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"portInputDidChange:"), "NSControlTextDidChangeNotification", (NSObject)this.portField);
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.updateField(BookmarkController.this.portField, String.valueOf(bookmark.getPort()));
                BookmarkController.this.portField.setEnabled(bookmark.getProtocol().isPortConfigurable());
            }
        });
    }

    public void portInputDidChange(NSNotification sender) {
        try {
            this.bookmark.setPort(Integer.valueOf(this.portField.stringValue()).intValue());
        }
        catch (NumberFormatException e) {
            this.bookmark.setPort(-1);
        }
        this.update();
    }

    public void setPathField(NSTextField field) {
        this.pathField = field;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"pathInputDidChange:"), "NSControlTextDidChangeNotification", (NSObject)this.pathField);
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.updateField(BookmarkController.this.pathField, bookmark.getDefaultPath());
            }
        });
    }

    public void pathInputDidChange(NSNotification sender) {
        this.bookmark.setDefaultPath(this.pathField.stringValue());
        this.update();
    }

    public void setUrlField(NSTextField field) {
        this.urlField = field;
        this.urlField.setAllowsEditingTextAttributes(true);
        this.urlField.setSelectable(true);
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.urlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((String)new HostUrlProvider(true, true).get(bookmark)));
            }
        });
    }

    public void setUsernameField(NSTextField field) {
        this.usernameField = field;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"usernameInputDidChange:"), "NSControlTextDidChangeNotification", (NSObject)this.usernameField);
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.updateField(BookmarkController.this.usernameField, BookmarkController.this.credentials.getUsername());
                BookmarkController.this.usernameField.cell().setPlaceholderString(bookmark.getProtocol().getUsernamePlaceholder());
                BookmarkController.this.usernameField.setEnabled(BookmarkController.this.options.user && !BookmarkController.this.credentials.isAnonymousLogin());
            }
        });
    }

    public void usernameInputDidChange(NSNotification sender) {
        this.credentials.setUsername(this.usernameField.stringValue());
        this.update();
    }

    public void setUsernameLabel(final NSTextField usernameLabel) {
        this.usernameLabel = usernameLabel;
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                usernameLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isNotBlank((CharSequence)BookmarkController.this.credentials.getUsernamePlaceholder()) ? String.format("%s:", BookmarkController.this.credentials.getUsernamePlaceholder()) : ""), (NSDictionary)BundleController.LABEL_ATTRIBUTES));
            }
        });
    }

    public void setAnonymousCheckbox(NSButton button) {
        this.anonymousCheckbox = button;
        this.anonymousCheckbox.setTarget(this.id());
        this.anonymousCheckbox.setAction(Foundation.selector((String)"anonymousCheckboxClicked:"));
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                BookmarkController.this.anonymousCheckbox.setEnabled(BookmarkController.this.options.anonymous && bookmark.getProtocol().isAnonymousConfigurable());
                BookmarkController.this.anonymousCheckbox.setState(BookmarkController.this.credentials.isAnonymousLogin() ? 1 : 0);
            }
        });
    }

    public void anonymousCheckboxClicked(NSButton sender) {
        if (sender.state() == 1) {
            this.credentials.setUsername(this.preferences.getProperty("connection.login.anon.name"));
            this.credentials.setPassword(this.preferences.getProperty("connection.login.anon.pass"));
        }
        if (sender.state() == 0) {
            if (this.preferences.getProperty("connection.login.name").equals(this.preferences.getProperty("connection.login.anon.name"))) {
                this.credentials.setUsername("");
            } else {
                this.credentials.setUsername(this.preferences.getProperty("connection.login.name"));
            }
            this.credentials.setPassword(null);
        }
        this.update();
    }

    public void invalidate() {
        this.observers.clear();
        super.invalidate();
    }

    protected String getBundleName() {
        return "Bookmark";
    }

    public void awakeFromNib() {
        super.awakeFromNib();
        if (this.bookmark.getProtocol().isHostnameConfigurable()) {
            this.window.makeFirstResponder((NSResponder)this.hostField);
        }
        this.update();
    }

    public void setWindow(final NSWindow window) {
        window.setContentMinSize(window.frame().size);
        window.setContentMaxSize(new NSSize(600.0, window.frame().size.height.doubleValue()));
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                window.setTitle(BookmarkNameProvider.toString((Host)bookmark));
            }
        });
        super.setWindow(window);
        cascade = this.cascade(cascade);
    }

    public void windowWillClose(NSNotification notification) {
        cascade = new NSPoint(this.window().frame().origin.x.doubleValue(), this.window().frame().origin.y.doubleValue() + this.window().frame().size.height.doubleValue());
        super.windowWillClose(notification);
    }

    public void setPrivateKeyPopup(NSPopUpButton button) {
        this.privateKeyPopup = button;
        this.privateKeyPopup.setTarget(this.id());
        Selector action = Foundation.selector((String)"privateKeyPopupClicked:");
        this.privateKeyPopup.setAction(action);
        this.privateKeyPopup.removeAllItems();
        this.privateKeyPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.privateKeyPopup.lastItem().setRepresentedObject("");
        this.privateKeyPopup.menu().addItem(NSMenuItem.separatorItem());
        for (Local key : new OpenSSHPrivateKeyConfigurator().list()) {
            this.privateKeyPopup.addItemWithTitle(key.getAbbreviatedPath());
            this.privateKeyPopup.lastItem().setRepresentedObject(key.getAbsolute());
        }
        this.privateKeyPopup.menu().addItem(NSMenuItem.separatorItem());
        this.privateKeyPopup.addItemWithTitle(String.format("%s\u2026", LocaleFactory.localizedString((String)"Choose")));
        this.addObserver(new BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                Local key;
                BookmarkController.this.privateKeyPopup.setEnabled(bookmark.getProtocol().getType() == Protocol.Type.sftp);
                if (BookmarkController.this.credentials.isPublicKeyAuthentication()) {
                    BookmarkController.this.privateKeyPopup.selectItemAtIndex(BookmarkController.this.privateKeyPopup.indexOfItemWithRepresentedObject(BookmarkController.this.credentials.getIdentity().getAbsolute()));
                } else {
                    BookmarkController.this.privateKeyPopup.selectItemWithTitle(LocaleFactory.localizedString((String)"None"));
                }
                if (BookmarkController.this.credentials.isPublicKeyAuthentication() && -1 == BookmarkController.this.privateKeyPopup.indexOfItemWithRepresentedObject((key = BookmarkController.this.credentials.getIdentity()).getAbsolute()).intValue()) {
                    NSInteger index = new NSInteger(0L);
                    BookmarkController.this.privateKeyPopup.insertItemWithTitle_atIndex(key.getAbbreviatedPath(), index);
                    BookmarkController.this.privateKeyPopup.itemAtIndex(index).setRepresentedObject(key.getAbsolute());
                }
            }
        });
    }

    public void privateKeyPopupClicked(NSPopUpButton sender) {
        String selected = sender.selectedItem().representedObject();
        if (null == selected) {
            this.privateKeyOpenPanel = NSOpenPanel.openPanel();
            this.privateKeyOpenPanel.setCanChooseDirectories(false);
            this.privateKeyOpenPanel.setCanChooseFiles(true);
            this.privateKeyOpenPanel.setAllowsMultipleSelection(false);
            this.privateKeyOpenPanel.setMessage(LocaleFactory.localizedString((String)"Select the private key in PEM or PuTTY format", (String)"Credentials"));
            this.privateKeyOpenPanel.setPrompt(LocaleFactory.localizedString((String)"Choose"));
            this.privateKeyOpenPanel.beginSheetForDirectory(OpenSSHPrivateKeyConfigurator.OPENSSH_CONFIGURATION_DIRECTORY.getAbsolute(), null, this.window(), this.id(), Foundation.selector((String)"privateKeyPanelDidEnd:returnCode:contextInfo:"), null);
        } else {
            this.credentials.setIdentity(StringUtils.isBlank((CharSequence)selected) ? null : LocalFactory.get((String)selected));
        }
        this.update();
    }

    public void privateKeyPanelDidEnd_returnCode_contextInfo(NSOpenPanel sheet, int returncode, ID contextInfo) {
        switch (returncode) {
            case 1: {
                NSObject selected = this.privateKeyOpenPanel.filenames().lastObject();
                if (selected == null) break;
                Local key = LocalFactory.get((String)selected.toString());
                this.credentials.setIdentity(key);
                break;
            }
            case 0: {
                this.credentials.setIdentity(null);
            }
        }
        this.update();
    }

    public void helpButtonClicked(ID sender) {
        BrowserLauncherFactory.get().open(new DefaultProviderHelpService().help(this.bookmark.getProtocol()));
    }

    protected void update() {
        for (BookmarkObserver observer : this.observers) {
            observer.change(this.bookmark);
        }
    }

    public void addObserver(BookmarkObserver observer) {
        this.observers.add(0, observer);
    }

    public void collectionLoaded() {
    }

    public void collectionItemAdded(Object item) {
    }

    public void collectionItemRemoved(Object item) {
        NSWindow window;
        if (item.equals(this.bookmark) && null != (window = this.window())) {
            window.close();
        }
    }

    public void collectionItemChanged(Object item) {
        this.update();
    }

    public void callback(int returncode) {
    }

    public static interface BookmarkObserver {
        public void change(Host var1);
    }
}

