/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.cyberduck.ui.cocoa.controller.ExtendedBookmarkController;
import java.util.HashMap;
import java.util.Map;

public final class BookmarkControllerFactory {
    private static final Map<Host, BookmarkController> open = new HashMap<Host, BookmarkController>();

    private BookmarkControllerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BookmarkController create(final AbstractHostCollection collection, Host host) {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (!open.containsKey(host)) {
                ExtendedBookmarkController c = new ExtendedBookmarkController(host){

                    @Override
                    public void invalidate() {
                        open.remove(this.bookmark);
                        super.invalidate();
                    }
                };
                c.addObserver(new BookmarkController.BookmarkObserver(){

                    @Override
                    public void change(Host bookmark) {
                        collection.collectionItemChanged((Object)bookmark);
                    }
                });
                c.loadBundle();
                open.put(host, c);
            }
            return open.get(host);
        }
    }
}

