/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.InputValidator;
import ch.cyberduck.ui.LoginInputValidator;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;

public class ConnectionController
extends BookmarkController {
    private final HostPasswordStore keychain = PasswordStoreFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private NSTextField passwordField;
    private NSTextField passwordLabel;
    private NSButton keychainCheckbox;

    public ConnectionController(Host bookmark) {
        this(bookmark, bookmark.getCredentials());
    }

    public ConnectionController(Host bookmark, Credentials credentials) {
        this(bookmark, credentials, new LoginOptions(bookmark.getProtocol()));
    }

    public ConnectionController(Host bookmark, Credentials credentials, LoginOptions options) {
        super(bookmark, credentials, (InputValidator)new LoginInputValidator(credentials, bookmark.getProtocol(), options), options);
    }

    @Override
    public void awakeFromNib() {
        super.awakeFromNib();
        if (this.options.user) {
            this.window.makeFirstResponder((NSResponder)this.usernameField);
        }
        if (this.options.password) {
            this.window.makeFirstResponder((NSResponder)this.passwordField);
        }
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    protected String getBundleName() {
        return "Connection";
    }

    @Override
    public void callback(int returncode) {
        if (-1 == returncode) {
            this.credentials.setPassword(null);
        }
    }

    public void windowDidBecomeKey(NSNotification notification) {
        this.updateField(this.usernameField, this.credentials.getUsername());
        this.updateField(this.passwordField, this.credentials.getPassword());
    }

    public void setPasswordField(NSSecureTextField field) {
        this.passwordField = field;
        this.updateField(this.passwordField, this.credentials.getPassword());
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"passwordFieldTextDidChange:"), "NSControlTextDidChangeNotification", (NSObject)this.passwordField);
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                ConnectionController.this.passwordField.cell().setPlaceholderString(ConnectionController.this.credentials.getPasswordPlaceholder());
                ConnectionController.this.passwordField.setEnabled(ConnectionController.this.options.password && !ConnectionController.this.credentials.isAnonymousLogin());
                if (ConnectionController.this.preferences.getBoolean("connection.login.keychain")) {
                    if (StringUtils.isBlank((CharSequence)bookmark.getHostname())) {
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)ConnectionController.this.credentials.getUsername())) {
                        return;
                    }
                    String password = ConnectionController.this.keychain.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), ConnectionController.this.credentials.getUsername());
                    if (StringUtils.isNotBlank((CharSequence)password)) {
                        ConnectionController.this.credentials.setPassword(password);
                        ConnectionController.this.updateField(ConnectionController.this.passwordField, password);
                    }
                }
            }
        });
    }

    public void passwordFieldTextDidChange(NSNotification notification) {
        this.credentials.setPassword(this.passwordField.stringValue());
    }

    public void setPasswordLabel(final NSTextField passwordLabel) {
        this.passwordLabel = passwordLabel;
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                passwordLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isNotBlank((CharSequence)ConnectionController.this.credentials.getPasswordPlaceholder()) ? String.format("%s:", ConnectionController.this.credentials.getPasswordPlaceholder()) : ""), (NSDictionary)BundleController.LABEL_ATTRIBUTES));
            }
        });
    }

    public void setKeychainCheckbox(final NSButton keychainCheckbox) {
        this.keychainCheckbox = keychainCheckbox;
        this.keychainCheckbox.setTarget(this.id());
        this.keychainCheckbox.setAction(Foundation.selector((String)"keychainCheckboxClicked:"));
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                keychainCheckbox.setEnabled(ConnectionController.this.options.keychain);
                keychainCheckbox.setState(ConnectionController.this.credentials.isSaved() ? 1 : 0);
            }
        });
    }

    public void keychainCheckboxClicked(NSButton sender) {
        this.credentials.setSaved(sender.state() == 1);
    }
}

