/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.controller.ConnectionController;
import java.util.HashMap;
import java.util.Map;

public final class ConnectionControllerFactory {
    private static final Map<WindowController, ConnectionController> open = new HashMap<WindowController, ConnectionController>();

    private ConnectionControllerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionController create(final WindowController parent) {
        NSApplication nSApplication = NSApplication.sharedApplication();
        synchronized (nSApplication) {
            if (!open.containsKey(parent)) {
                ConnectionController c = new ConnectionController(new Host(ProtocolFactory.forName((String)PreferencesFactory.get().getProperty("connection.protocol.default")), PreferencesFactory.get().getProperty("connection.hostname.default"), PreferencesFactory.get().getInteger("connection.port.default"))){

                    @Override
                    public void invalidate() {
                        open.remove(parent);
                        super.invalidate();
                    }
                };
                c.loadBundle();
                open.put(parent, c);
                return c;
            }
            ConnectionController c = open.get(parent);
            c.loadBundle();
            return c;
        }
    }
}

