/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;

public class DonateAlertController
extends AlertController {
    private final Preferences preferences = PreferencesFactory.get();
    private final NSApplication app;

    public DonateAlertController(NSApplication app) {
        this.app = app;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setMessageText(LocaleFactory.localizedString((String)"Thank you for using Cyberduck!", (String)"Donate"));
        StringAppender message = new StringAppender();
        message.append(LocaleFactory.localizedString((String)"It has taken many nights to develop this application. If you enjoy using it, please consider a donation to the author of this software. It will help to make Cyberduck even better!", (String)"Donate"));
        message.append(LocaleFactory.localizedString((String)"As a contributor to Cyberduck, you receive a donation key that disables this prompt.", (String)"Donate"));
        alert.setInformativeText(message.toString());
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Donate!", (String)"Donate"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Later", (String)"Donate"));
        alert.setAlertStyle(1);
        alert.setShowsSuppressionButton(true);
        alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't show again for this version.", (String)"Donate"));
        this.loadBundle(alert);
    }

    public void callback(int returncode) {
        if (this.isSuppressed()) {
            this.preferences.setProperty("donate.reminder", NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleShortVersionString").toString());
        }
        this.preferences.setProperty("donate.reminder.date", System.currentTimeMillis());
        switch (returncode) {
            case 1: {
                BrowserLauncherFactory.get().open(this.preferences.getProperty("website.donate"));
            }
        }
        this.terminate();
    }

    private void terminate() {
        if (this.isSuppressed()) {
            this.preferences.setProperty("donate.reminder", NSBundle.mainBundle().infoDictionary().objectForKey("CFBundleShortVersionString").toString());
        }
        this.preferences.setProperty("donate.reminder.date", System.currentTimeMillis());
        this.app.replyToApplicationShouldTerminate(true);
    }
}

