/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.core.DefaultPathKindDetector;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathKindDetector;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.ui.cocoa.controller.TransferControllerFactory;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.cocoa.foundation.NSRect;

public class DownloadController
extends AlertController {
    protected final NSTextField urlField = NSTextField.textfieldWithFrame((NSRect)new NSRect(0.0, 22.0));
    private final PathKindDetector detector = new DefaultPathKindDetector();
    private final String url;

    public DownloadController() {
        this("");
    }

    public DownloadController(String url) {
        this.url = url;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"New Download", (String)"Download"));
        alert.setInformativeText(LocaleFactory.localizedString((String)"URL", (String)"Download"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Download", (String)"Download"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Download"));
        this.loadBundle(alert);
    }

    public NSView getAccessoryView(NSAlert alert) {
        return this.urlField;
    }

    protected void focus(NSAlert alert) {
        super.focus(alert);
        this.updateField(this.urlField, this.url);
        this.urlField.selectText(null);
    }

    public void callback(int returncode) {
        switch (returncode) {
            case 1: {
                Host host = HostParser.parse((String)this.urlField.stringValue());
                Path file = new Path(PathNormalizer.normalize((String)host.getDefaultPath(), (boolean)true), EnumSet.of(this.detector.detect(host.getDefaultPath())));
                host.setDefaultPath(file.getParent().getAbsolute());
                DownloadTransfer transfer = new DownloadTransfer(host, file, LocalFactory.get((String)PreferencesFactory.get().getProperty("queue.download.folder"), (String)file.getName()));
                TransferControllerFactory.get().start((Transfer)transfer, new TransferOptions());
            }
        }
    }

    public boolean validate() {
        Host host = HostParser.parse((String)this.urlField.stringValue());
        return StringUtils.isNotBlank((CharSequence)host.getDefaultPath());
    }

    protected String help() {
        return new DefaultProviderHelpService().help("/howto/download");
    }
}

