/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.HyperlinkAttributedStringFactory;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.cyberduck.ui.cocoa.controller.ConnectionController;

public class LoginController
extends ConnectionController {
    private final String title;
    private final String reason;
    private NSImageView iconView;
    private NSTextField titleField;
    private NSTextField textField;

    public LoginController(String title, String reason, Host bookmark, Credentials credentials, final LoginOptions options) {
        super(bookmark, credentials, options);
        this.title = title;
        this.reason = reason;
        this.addObserver(new BookmarkController.BookmarkObserver(){

            @Override
            public void change(Host bookmark) {
                if (!options.user) {
                    LoginController.this.usernameField.setEnabled(false);
                }
                if (!options.anonymous) {
                    LoginController.this.anonymousCheckbox.setEnabled(false);
                    LoginController.this.anonymousCheckbox.setState(0);
                }
                if (!options.publickey) {
                    LoginController.this.privateKeyPopup.setEnabled(false);
                    LoginController.this.privateKeyPopup.selectItemWithTitle(LocaleFactory.localizedString((String)"None"));
                }
            }
        });
    }

    @Override
    protected String getBundleName() {
        return "Login";
    }

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
        this.iconView.setImage(this.options.icon != null ? (NSImage)IconCacheFactory.get().iconNamed(this.options.icon) : (NSImage)IconCacheFactory.get().iconNamed(this.bookmark.getProtocol().disk()));
    }

    public void setTitleField(NSTextField titleField) {
        this.titleField = titleField;
        this.updateField(this.titleField, LocaleFactory.localizedString((String)this.title, (String)"Credentials"));
    }

    public void setTextField(NSTextField textField) {
        this.textField = textField;
        this.textField.setSelectable(true);
        if (this.reason.startsWith(Scheme.http.name())) {
            this.textField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((String)this.reason));
            this.textField.setAllowsEditingTextAttributes(true);
            this.textField.setSelectable(true);
        } else {
            this.updateField(this.textField, new StringAppender().append(this.reason).toString());
        }
    }
}

