/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSSecureTextField;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.resources.IconCacheFactory;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class PasswordController
extends AlertController {
    private NSView view;
    private NSSecureTextField inputField;
    private NSButton keychainCheckbox;
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private final Credentials credentials;
    private final String title;
    private final String reason;
    private final LoginOptions options;

    public PasswordController(Credentials credentials, String title, String reason, LoginOptions options) {
        this.credentials = credentials;
        this.title = title;
        this.reason = reason;
        this.options = options;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setIcon((NSImage)IconCacheFactory.get().iconNamed(this.options.icon, Integer.valueOf(64)));
        alert.setMessageText(this.title);
        alert.setInformativeText(this.reason);
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Unlock Vault", (String)"Cryptomator"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Alert"));
        this.loadBundle(alert);
    }

    public void keychainCheckboxClicked(NSButton sender) {
        this.credentials.setSaved(sender.state() == 1);
    }

    public void passwordFieldTextDidChange(NSNotification notification) {
        this.credentials.setPassword(this.inputField.stringValue());
    }

    public NSView getAccessoryView(NSAlert alert) {
        this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
        if (this.options.keychain) {
            this.keychainCheckbox = NSButton.buttonWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 18.0));
            this.keychainCheckbox.setTitle(LocaleFactory.localizedString((String)"Save Password", (String)"Keychain"));
            this.keychainCheckbox.setAction(Foundation.selector((String)"keychainCheckboxClicked:"));
            this.keychainCheckbox.setTarget(this.id());
            this.keychainCheckbox.setButtonType(3);
            this.keychainCheckbox.setState(0);
            this.keychainCheckbox.sizeToFit();
            this.keychainCheckbox.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue()));
            this.view.addSubview((NSView)this.keychainCheckbox);
        }
        this.inputField = NSSecureTextField.textfieldWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 22.0));
        this.inputField.cell().setPlaceholderString(this.credentials.getPasswordPlaceholder());
        this.inputField.setFrameOrigin(new NSPoint(0.0, this.getFrame((NSAlert)alert, (NSView)this.view).size.height.doubleValue() + this.view.subviews().count().doubleValue() * 4.0));
        this.view.addSubview((NSView)this.inputField);
        return this.view;
    }

    protected void focus(NSAlert alert) {
        super.focus(alert);
        this.inputField.selectText(null);
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"passwordFieldTextDidChange:"), "NSControlTextDidChangeNotification", (NSObject)this.inputField);
    }

    public boolean validate() {
        return StringUtils.isNotBlank((CharSequence)this.inputField.stringValue());
    }

    protected String help() {
        return new DefaultProviderHelpService().help("/howto/cryptomator");
    }
}

