/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Set;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;

public class RegionController
extends AlertController {
    private NSView view;
    private NSPopUpButton regionPopup;
    private final Set<Location.Name> regions;
    private final Callback callback;

    public RegionController(Set<Location.Name> regions, Callback callback) {
        this.regions = regions;
        this.callback = callback;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Choose Region", (String)"Folder"));
        alert.setInformativeText(LocaleFactory.localizedString((String)"Enter the name for the new folder", (String)"Folder"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Choose"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Folder"));
        super.loadBundle(alert);
    }

    public NSView getAccessoryView(NSAlert alert) {
        this.view = NSView.create((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 0.0));
        this.regionPopup = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(alert.window().frame().size.width.doubleValue(), 26.0));
        this.regionPopup.setFrameOrigin(new NSPoint(0.0, 0.0));
        for (Location.Name region : this.regions) {
            this.regionPopup.addItemWithTitle(region.toString());
            this.regionPopup.itemWithTitle(region.toString()).setRepresentedObject(region.getIdentifier());
            if (!region.getIdentifier().equals(PreferencesFactory.get().getProperty("s3.location"))) continue;
            this.regionPopup.selectItem(this.regionPopup.lastItem());
        }
        this.view.addSubview((NSView)this.regionPopup);
        return this.view;
    }

    public void callback(int returncode) {
        switch (returncode) {
            case 1: {
                this.callback.callback(new Location.Name(this.regionPopup.selectedItem().representedObject()));
            }
        }
    }

    public static interface Callback {
        public void callback(Location.Name var1);
    }
}

