/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSButtonCell;
import ch.cyberduck.binding.application.NSCell;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageCell;
import ch.cyberduck.binding.application.NSLayoutManager;
import ch.cyberduck.binding.application.NSOutlineView;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextFieldCell;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NSObjectTransferItemReference;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.TransferItemCache;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.ui.cocoa.controller.AbstractPathTableDelegate;
import ch.cyberduck.ui.cocoa.controller.TableColumnFactory;
import ch.cyberduck.ui.cocoa.datasource.TransferPromptDataSource;
import ch.cyberduck.ui.cocoa.view.OutlineCell;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class TransferPromptController
extends SheetController
implements TransferPrompt,
ProgressListener,
TranscriptListener {
    private static final Logger log = Logger.getLogger(TransferPromptController.class);
    private static final NSAttributedString UNKNOWN_STRING = NSAttributedString.attributedStringWithAttributes((String)LocaleFactory.localizedString((String)"Unknown"), (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES);
    protected final Transfer transfer;
    protected final Cache<TransferItem> cache = new TransferItemCache(Integer.MAX_VALUE);
    protected final NSButtonCell buttonCellPrototype = NSButtonCell.buttonCell();
    protected final NSTextFieldCell outlineCellPrototype = OutlineCell.outlineCell();
    protected final NSImageCell imageCellPrototype = NSImageCell.imageCell();
    protected final NSTextFieldCell textCellPrototype = NSTextFieldCell.textFieldCell();
    final NSLayoutManager layoutManager = NSLayoutManager.layoutManager();
    private final TableColumnFactory tableColumnsFactory = new TableColumnFactory();
    private final Preferences preferences = PreferencesFactory.get();
    private final WindowController parent;
    private TransferAction action;
    protected TransferPromptDataSource browserModel;
    protected AbstractPathTableDelegate browserViewDelegate;
    private NSOutlineView browserView;
    private NSButton toggleDetailsButton;
    private NSTextField remoteURLField;
    private NSTextField remoteSizeField;
    private NSTextField remoteModificationField;
    private NSTextField localURLField;
    private NSTextField localSizeField;
    private NSTextField localModificationField;
    private NSProgressIndicator statusIndicator;
    private NSTextField statusLabel;
    private NSPopUpButton actionPopup;

    public TransferPromptController(WindowController parent, Transfer transfer) {
        this.parent = parent;
        this.transfer = transfer;
        this.action = TransferAction.forName((String)this.preferences.getProperty(String.format("queue.prompt.%s.action.default", transfer.getType().name())));
    }

    protected String getBundleName() {
        return "Prompt";
    }

    public void setWindow(NSWindow window) {
        window.setContentMinSize(window.frame().size);
        super.setWindow(window);
    }

    public void setToggleDetailsButton(NSButton toggleDetailsButton) {
        this.toggleDetailsButton = toggleDetailsButton;
    }

    public void awakeFromNib() {
        this.setState(this.toggleDetailsButton, this.preferences.getBoolean("transfer.toggle.details"));
        super.awakeFromNib();
    }

    public void invalidate() {
        this.browserView.setDataSource(null);
        this.browserView.setDelegate(null);
        super.invalidate();
    }

    public void message(String message) {
        if (null == this.statusLabel) {
            return;
        }
        this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)message, (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public void reload() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reload table view");
        }
        this.browserView.reloadData();
        this.browserView.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger(0L)), false);
        this.statusLabel.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)MessageFormat.format(LocaleFactory.localizedString((String)"{0} Files"), String.valueOf(this.browserView.numberOfRows())), (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    public TransferAction prompt(TransferItem file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Prompt for transfer action of %s", this.transfer));
        }
        new SheetInvoker((SheetCallback)this, this.parent, (WindowController)this).beginSheet();
        return this.action;
    }

    public void callback(int returncode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Callback with return code %d", returncode));
        }
        if (returncode == -1) {
            this.action = TransferAction.cancel;
        }
        this.preferences.setProperty("transfer.toggle.details", this.toggleDetailsButton.state());
    }

    public boolean isSelected(TransferItem file) {
        return this.browserModel.isSelected(file);
    }

    public void setBrowserView(NSOutlineView view) {
        this.browserView = view;
        this.browserView.setHeaderView(null);
        this.browserView.setRowHeight(new CGFloat((double)(this.layoutManager.defaultLineHeightForFont(NSFont.systemFontOfSize((double)this.preferences.getFloat("browser.font.size"))).intValue() + 2)));
        NSTableColumn c = this.tableColumnsFactory.create(TransferPromptDataSource.Column.filename.name());
        c.headerCell().setStringValue(LocaleFactory.localizedString((String)"Filename"));
        c.setMinWidth(100.0);
        c.setWidth(220.0);
        c.setMaxWidth(800.0);
        c.setResizingMask(3);
        c.setEditable(false);
        c.setDataCell((NSCell)this.outlineCellPrototype);
        this.browserView.addTableColumn(c);
        this.browserView.setOutlineTableColumn(c);
        c = this.tableColumnsFactory.create(TransferPromptDataSource.Column.size.name());
        c.headerCell().setStringValue("");
        c.setMinWidth(50.0);
        c.setWidth(80.0);
        c.setMaxWidth(100.0);
        c.setResizingMask(3);
        c.setEditable(false);
        c.setDataCell((NSCell)this.textCellPrototype);
        this.browserView.addTableColumn(c);
        c = this.tableColumnsFactory.create(TransferPromptDataSource.Column.warning.name());
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setEditable(false);
        c.setDataCell((NSCell)this.imageCellPrototype);
        c.dataCell().setAlignment(2);
        this.browserView.addTableColumn(c);
        c = this.tableColumnsFactory.create(TransferPromptDataSource.Column.include.name());
        c.headerCell().setStringValue("");
        c.setMinWidth(20.0);
        c.setWidth(20.0);
        c.setMaxWidth(20.0);
        c.setResizingMask(1);
        c.setEditable(false);
        NSButtonCell cell = this.buttonCellPrototype;
        cell.setTitle("");
        cell.setControlSize(1);
        cell.setButtonType(3);
        cell.setAllowsMixedState(false);
        cell.setTarget(this.id());
        cell.setAlignment(2);
        c.setDataCell((NSCell)cell);
        this.browserView.addTableColumn(c);
        this.browserView.setDataSource(this.browserModel.id());
        this.browserViewDelegate = new AbstractPathTableDelegate(this.browserView.tableColumnWithIdentifier(TransferPromptDataSource.Column.filename.name())){

            public void enterKeyPressed(ID sender) {
            }

            public void deleteKeyPressed(ID sender) {
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn tableColumn) {
            }

            public void tableRowDoubleClicked(ID sender) {
            }

            public void selectionDidChange(NSNotification notification) {
                if (TransferPromptController.this.browserView.selectedRow().intValue() == -1) {
                    TransferPromptController.this.remoteURLField.setStringValue("");
                    TransferPromptController.this.remoteSizeField.setStringValue("");
                    TransferPromptController.this.remoteModificationField.setStringValue("");
                    TransferPromptController.this.localURLField.setStringValue("");
                    TransferPromptController.this.localSizeField.setStringValue("");
                    TransferPromptController.this.localModificationField.setStringValue("");
                } else {
                    TransferItem item = (TransferItem)TransferPromptController.this.cache.lookup((CacheReference)new NSObjectTransferItemReference(TransferPromptController.this.browserView.itemAtRow(TransferPromptController.this.browserView.selectedRow())));
                    if (item.local != null) {
                        TransferPromptController.this.localURLField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)item.local.getAbsolute(), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        if (item.local.attributes().getSize() == -1L) {
                            TransferPromptController.this.localSizeField.setAttributedStringValue(UNKNOWN_STRING);
                        } else {
                            TransferPromptController.this.localSizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)SizeFormatterFactory.get().format(item.local.attributes().getSize()), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        }
                        if (item.local.attributes().getModificationDate() == -1L) {
                            TransferPromptController.this.localModificationField.setAttributedStringValue(UNKNOWN_STRING);
                        } else {
                            TransferPromptController.this.localModificationField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)UserDateFormatterFactory.get().getLongFormat(item.local.attributes().getModificationDate()), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                        }
                    }
                    TransferPromptController.this.remoteURLField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)new DefaultUrlProvider(TransferPromptController.this.transfer.getSource()).toUrl(item.remote).find(DescriptiveUrl.Type.provider).getUrl(), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                    TransferStatus status = TransferPromptController.this.browserModel.getStatus(item);
                    if (status.getRemote().getSize() == -1L) {
                        TransferPromptController.this.remoteSizeField.setAttributedStringValue(UNKNOWN_STRING);
                    } else {
                        TransferPromptController.this.remoteSizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)SizeFormatterFactory.get().format(status.getRemote().getSize()), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                    }
                    if (status.getRemote().getModificationDate() == -1L) {
                        TransferPromptController.this.remoteModificationField.setAttributedStringValue(UNKNOWN_STRING);
                    } else {
                        TransferPromptController.this.remoteModificationField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)UserDateFormatterFactory.get().getLongFormat(status.getRemote().getModificationDate()), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                    }
                }
            }

            protected boolean isTypeSelectSupported() {
                return true;
            }

            public String tableView_typeSelectStringForTableColumn_row(NSTableView view, NSTableColumn column, NSInteger row) {
                return ((TransferItem)TransferPromptController.this.cache.lookup((CacheReference)new NSObjectTransferItemReference((NSObject)((TransferPromptController)TransferPromptController.this).browserView.itemAtRow((NSInteger)row)))).remote.getName();
            }

            public void outlineView_willDisplayCell_forTableColumn_item(NSOutlineView view, NSCell cell, NSTableColumn column, NSObject item) {
                String identifier = column.identifier();
                TransferItem file = (TransferItem)TransferPromptController.this.cache.lookup((CacheReference)new NSObjectTransferItemReference(item));
                TransferStatus status = TransferPromptController.this.browserModel.getStatus(file);
                if (identifier.equals(TransferPromptDataSource.Column.include.name())) {
                    cell.setEnabled(!status.isRejected() && status.isExists());
                }
                if (identifier.equals(TransferPromptDataSource.Column.filename.name())) {
                    ((OutlineCell)Rococoa.cast((ObjCObject)cell, OutlineCell.class)).setIcon((NSImage)IconCacheFactory.get().fileIcon(file.remote, Integer.valueOf(16)));
                }
                if (cell.isKindOfClass(Foundation.getClass((String)NSTextFieldCell.class.getSimpleName()))) {
                    if (status.isRejected()) {
                        ((NSTextFieldCell)Rococoa.cast((ObjCObject)cell, NSTextFieldCell.class)).setTextColor(NSColor.disabledControlTextColor());
                    } else {
                        ((NSTextFieldCell)Rococoa.cast((ObjCObject)cell, NSTextFieldCell.class)).setTextColor(NSColor.controlTextColor());
                    }
                }
            }
        };
        this.browserView.setDelegate(this.browserViewDelegate.id());
        this.browserView.setAllowsMultipleSelection(true);
        this.browserView.setAllowsEmptySelection(true);
        this.browserView.setAllowsColumnResizing(true);
        this.browserView.setAllowsColumnSelection(false);
        this.browserView.setAllowsColumnReordering(true);
        this.browserView.setUsesAlternatingRowBackgroundColors(this.preferences.getBoolean("browser.alternatingRows"));
        if (this.preferences.getBoolean("browser.horizontalLines") && this.preferences.getBoolean("browser.verticalLines")) {
            this.browserView.setGridStyleMask(new NSUInteger((long)(NSTableView.NSTableViewSolidHorizontalGridLineMask.intValue() | NSTableView.NSTableViewSolidVerticalGridLineMask.intValue())));
        } else if (this.preferences.getBoolean("browser.verticalLines")) {
            this.browserView.setGridStyleMask(NSTableView.NSTableViewSolidVerticalGridLineMask);
        } else if (this.preferences.getBoolean("browser.horizontalLines")) {
            this.browserView.setGridStyleMask(NSTableView.NSTableViewSolidHorizontalGridLineMask);
        } else {
            this.browserView.setGridStyleMask(NSTableView.NSTableViewGridNone);
        }
        this.browserView.sizeToFit();
    }

    public void setRemoteURLField(NSTextField f) {
        this.remoteURLField = f;
    }

    public void setRemoteSizeField(NSTextField f) {
        this.remoteSizeField = f;
    }

    public void setRemoteModificationField(NSTextField f) {
        this.remoteModificationField = f;
    }

    public void setLocalURLField(NSTextField f) {
        this.localURLField = f;
    }

    public void setLocalSizeField(NSTextField f) {
        this.localSizeField = f;
    }

    public void setLocalModificationField(NSTextField f) {
        this.localModificationField = f;
    }

    public void setStatusIndicator(NSProgressIndicator f) {
        this.statusIndicator = f;
        this.statusIndicator.setDisplayedWhenStopped(false);
    }

    public void setStatusLabel(NSTextField f) {
        this.statusLabel = f;
    }

    public void setActionPopup(NSPopUpButton actionPopup) {
        this.actionPopup = actionPopup;
        this.actionPopup.removeAllItems();
        this.actionPopup.setAutoenablesItems(false);
        TransferAction defaultAction = TransferAction.forName((String)this.preferences.getProperty(String.format("queue.prompt.%s.action.default", this.transfer.getType().name())));
        for (TransferAction action : TransferAction.forTransfer((Transfer.Type)this.transfer.getType())) {
            this.actionPopup.addItemWithTitle(action.getTitle());
            this.actionPopup.lastItem().setRepresentedObject(action.name());
            if (action.equals((Object)defaultAction)) {
                this.actionPopup.selectItem(actionPopup.lastItem());
            }
            this.actionPopup.addItemWithTitle(action.getDescription());
            this.actionPopup.lastItem().setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)action.getDescription(), (NSDictionary)MENU_HELP_FONT_ATTRIBUTES));
            this.actionPopup.lastItem().setEnabled(false);
        }
        this.actionPopup.setTarget(this.id());
        this.actionPopup.setAction(Foundation.selector((String)"actionPopupClicked:"));
    }

    public void actionPopupClicked(NSPopUpButton sender) {
        TransferAction selected = TransferAction.forName((String)sender.selectedItem().representedObject());
        if (this.action.equals((Object)selected)) {
            return;
        }
        this.preferences.setProperty(String.format("queue.prompt.%s.action.default", this.transfer.getType().name()), selected.name());
        this.action = selected;
        this.browserModel.setAction(selected);
        this.reload();
    }

    public void log(TranscriptListener.Type request, String message) {
    }

    public void stop(BackgroundAction action) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                TransferPromptController.this.statusIndicator.stopAnimation(null);
            }
        });
    }

    public void start(BackgroundAction action) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                TransferPromptController.this.statusIndicator.startAnimation(null);
            }
        });
    }
}

