/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSOutlineView;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.NSObjectPathReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.datasource.BrowserTableDataSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class BrowserOutlineViewDataSource
extends BrowserTableDataSource
implements NSOutlineView.DataSource {
    private static final Logger log = Logger.getLogger(BrowserOutlineViewDataSource.class);

    public BrowserOutlineViewDataSource(BrowserController controller, Cache<Path> cache) {
        super(controller, cache);
    }

    @Override
    public void render(NSTableView view, List<Path> folders) {
        super.render(view, folders);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reload table view %s for changes files %s", view, folders));
        }
        if (this.controller.isMounted()) {
            NSOutlineView outline = (NSOutlineView)view;
            if (folders.isEmpty()) {
                view.reloadData();
            } else {
                for (Path folder : folders) {
                    if (folder.equals((Object)this.controller.workdir())) {
                        outline.reloadData();
                        break;
                    }
                    outline.reloadItem_reloadChildren(NSObjectPathReference.get((Path)folder), true);
                }
            }
        } else {
            view.reloadData();
        }
    }

    @Override
    public int indexOf(NSTableView view, Path file) {
        return ((NSOutlineView)view).rowForItem(NSObjectPathReference.get((Path)file)).intValue();
    }

    public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("outlineViewIsItemExpandable:" + item));
        }
        if (null == item) {
            return false;
        }
        Path lookup = (Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item));
        if (null == lookup) {
            return false;
        }
        return lookup.isDirectory();
    }

    public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("outlineView_numberOfChildrenOfItem:" + item));
        }
        if (this.controller.isMounted()) {
            Path lookup;
            if (null == item) {
                return new NSInteger((long)this.get(this.controller.workdir()).size());
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Current application event is %d", event.type()));
                }
                if (6 == event.type()) {
                    int draggingColumn = view.columnAtPoint(view.convertPoint_fromView(event.locationInWindow(), null)).intValue();
                    if (draggingColumn != 0) {
                        log.debug((Object)("Returning 0 to #outlineViewNumberOfChildrenOfItem for column:" + draggingColumn));
                        return new NSInteger(0L);
                    }
                    if (!PreferencesFactory.get().getBoolean("browser.view.autoexpand")) {
                        log.debug((Object)"Returning 0 to #outlineViewNumberOfChildrenOfItem while dragging because browser.view.autoexpand == false");
                        return new NSInteger(0L);
                    }
                }
            }
            if (null == (lookup = (Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item)))) {
                return new NSInteger(0L);
            }
            return new NSInteger((long)this.get(lookup).size());
        }
        return new NSInteger(0L);
    }

    public NSObject outlineView_child_ofItem(NSOutlineView view, NSInteger index, NSObject item) {
        Path path;
        if (log.isTraceEnabled()) {
            log.trace((Object)("outlineView_child_ofItem:" + item));
        }
        if (null == item) {
            path = this.controller.workdir();
        } else {
            path = (Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item));
            if (null == path) {
                return null;
            }
        }
        AttributedList<Path> children = this.get(path);
        if (index.intValue() >= children.size()) {
            log.warn((Object)String.format("Index %s out of bound for %s", index, item));
            return null;
        }
        return NSObjectPathReference.get((Path)((Path)children.get(index.intValue())));
    }

    public void outlineView_setObjectValue_forTableColumn_byItem(NSOutlineView view, NSObject value, NSTableColumn tableColumn, NSObject item) {
        super.setObjectValueForItem((Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item)), value, tableColumn.identifier());
    }

    public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
        if (null == item) {
            return null;
        }
        return super.objectValueForItem((Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item)), tableColumn.identifier());
    }

    public NSUInteger outlineView_validateDrop_proposedItem_proposedChildIndex(NSOutlineView view, NSDraggingInfo draggingInfo, NSObject item, NSInteger row) {
        if (this.controller.isMounted()) {
            Path destination = null;
            if (null != item) {
                destination = (Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item));
            }
            if (null == destination) {
                view.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
                return super.validateDrop((NSTableView)view, this.controller.workdir(), row, draggingInfo);
            }
            int draggingColumn = view.columnAtPoint(draggingInfo.draggingLocation()).intValue();
            if ((-1 == draggingColumn || 0 == draggingColumn) && destination.isDirectory()) {
                view.setDropItem(item, NSOutlineView.NSOutlineViewDropOnItemIndex);
                return super.validateDrop((NSTableView)view, destination, row, draggingInfo);
            }
            for (Path next : this.controller.getPasteboard()) {
                if (!destination.equals((Object)next)) continue;
                return NSDraggingInfo.NSDragOperationNone;
            }
            view.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
            return super.validateDrop((NSTableView)view, this.controller.workdir(), row, draggingInfo);
        }
        if (draggingInfo.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null) {
            view.setDropItem(null, NSOutlineView.NSOutlineViewDropOnItemIndex);
        }
        return super.validateDrop((NSTableView)view, null, row, draggingInfo);
    }

    public boolean outlineView_acceptDrop_item_childIndex(NSOutlineView view, NSDraggingInfo info, NSObject item, NSInteger row) {
        Path destination = null;
        if (this.controller.isMounted()) {
            if (null == item) {
                destination = this.controller.workdir();
            } else {
                destination = (Path)this.cache.lookup((CacheReference)new NSObjectPathReference(item));
                if (null == destination) {
                    return false;
                }
            }
        }
        return super.acceptDrop((NSTableView)view, destination, info);
    }

    public NSArray outlineView_namesOfPromisedFilesDroppedAtDestination_forDraggedItems(NSURL dropDestination, NSArray items) {
        return this.namesOfPromisedFilesDroppedAtDestination(dropDestination);
    }

    public boolean outlineView_writeItems_toPasteboard(NSOutlineView outlineView, NSArray items, NSPasteboard pboard) {
        ArrayList<Path> selected = new ArrayList<Path>();
        for (int i = 0; i < items.count().intValue(); ++i) {
            selected.add((Path)this.cache.lookup((CacheReference)new NSObjectPathReference(items.objectAtIndex(new NSUInteger((long)i)))));
        }
        return super.writeItemsToPasteBoard((NSTableView)outlineView, selected, pboard);
    }
}

