/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSDraggingInfo;
import ch.cyberduck.binding.application.NSDraggingSource;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.local.FileDescriptor;
import ch.cyberduck.core.local.FileDescriptorFactory;
import ch.cyberduck.core.local.IconServiceFactory;
import ch.cyberduck.core.local.LocalTouchFactory;
import ch.cyberduck.core.pasteboard.PathPasteboard;
import ch.cyberduck.core.pasteboard.PathPasteboardFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCache;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.transfer.CopyTransfer;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.ui.browser.Column;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.DeleteController;
import ch.cyberduck.ui.cocoa.controller.MoveController;
import ch.cyberduck.ui.cocoa.datasource.TableCellAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class BrowserTableDataSource
extends ProxyController
implements NSDraggingSource {
    private static final Logger log = Logger.getLogger(BrowserTableDataSource.class);
    private final SizeFormatter sizeFormatter = SizeFormatterFactory.get();
    private final AbstractUserDateFormatter dateFormatter = UserDateFormatterFactory.get();
    private final IconCache<NSImage> icons = IconCacheFactory.get();
    private final FileDescriptor descriptor = FileDescriptorFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private final Map<Item, NSAttributedString> attributed = new LRUMap(this.preferences.getInteger("browser.model.cache.size"));
    protected final BrowserController controller;
    protected final Cache<Path> cache;

    protected BrowserTableDataSource(BrowserController controller, Cache<Path> cache) {
        this.controller = controller;
        this.cache = cache;
    }

    public void render(NSTableView view, List<Path> folders) {
        this.attributed.clear();
    }

    public AttributedList<Path> get(Path directory) {
        return this.cache.get((Referenceable)directory).filter(this.controller.getComparator(), this.controller.getFilter());
    }

    public int indexOf(NSTableView view, Path file) {
        return this.get(this.controller.workdir()).indexOf((Referenceable)file);
    }

    protected void setObjectValueForItem(Path item, NSObject value, String identifier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set new value %s for item %s", value, item));
        }
        if (identifier.equals(Column.filename.name()) && StringUtils.isNotBlank((CharSequence)value.toString()) && !item.getName().equals(value.toString())) {
            Path renamed = new Path(item.getParent(), value.toString(), item.getType());
            new MoveController(this.controller).rename(item, renamed);
        }
    }

    public NSImage iconForPath(Path item) {
        if (item.isVolume()) {
            return (NSImage)this.icons.volumeIcon(this.controller.getSession().getHost().getProtocol(), Integer.valueOf(16));
        }
        return (NSImage)this.icons.fileIcon(item, Integer.valueOf(16));
    }

    protected NSObject objectValueForItem(Path item, String identifier) {
        if (null == item) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("objectValueForItem:" + item.getAbsolute()));
        }
        if (identifier.equals(Column.icon.name())) {
            return this.iconForPath(item);
        }
        Item key = new Item(item, identifier);
        NSAttributedString value = this.attributed.get(key);
        if (null != value) {
            return value;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Lookup failed for %s in cache", key));
        }
        if (identifier.equals(Column.filename.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)item.getName(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.size.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)this.sizeFormatter.format(item.attributes().getSize()), (NSDictionary)TableCellAttributes.browserFontRightAlignment());
        } else if (identifier.equals(Column.modified.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)this.dateFormatter.getShortFormat(item.attributes().getModificationDate(), this.preferences.getBoolean("browser.date.natural")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.owner.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isBlank((CharSequence)item.attributes().getOwner()) ? LocaleFactory.localizedString((String)"Unknown") : item.attributes().getOwner()), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.group.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isBlank((CharSequence)item.attributes().getGroup()) ? LocaleFactory.localizedString((String)"Unknown") : item.attributes().getGroup()), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.permission.name())) {
            Acl acl = item.attributes().getAcl();
            if (!Acl.EMPTY.equals((Object)acl)) {
                StringBuilder s = new StringBuilder();
                for (Map.Entry entry : acl.entrySet()) {
                    s.append(String.format("%s%s:%s", s.length() == 0 ? "" : ", ", ((Acl.User)entry.getKey()).getDisplayName(), entry.getValue()));
                }
                value = NSAttributedString.attributedStringWithAttributes((String)s.toString(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
            } else {
                Permission permission = item.attributes().getPermission();
                value = NSAttributedString.attributedStringWithAttributes((String)permission.toString(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
            }
        } else if (identifier.equals(Column.kind.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)this.descriptor.getKind(item), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.extension.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(item.isFile() ? (StringUtils.isNotBlank((CharSequence)item.getExtension()) ? item.getExtension() : LocaleFactory.localizedString((String)"None")) : LocaleFactory.localizedString((String)"None")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.region.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isNotBlank((CharSequence)item.attributes().getRegion()) ? item.attributes().getRegion() : LocaleFactory.localizedString((String)"Unknown")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else if (identifier.equals(Column.version.name())) {
            value = NSAttributedString.attributedStringWithAttributes((String)(StringUtils.isNotBlank((CharSequence)item.attributes().getVersionId()) ? item.attributes().getVersionId() : LocaleFactory.localizedString((String)"None")), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        } else {
            throw new IllegalArgumentException(String.format("Unknown identifier %s", identifier));
        }
        this.attributed.put(key, value);
        return value;
    }

    public boolean ignoreModifierKeysWhileDragging() {
        return false;
    }

    public NSUInteger draggingSourceOperationMaskForLocal(boolean local) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Request dragging source operation mask for %s", local));
        }
        if (local) {
            return new NSUInteger((long)(NSDraggingInfo.NSDragOperationMove.intValue() | NSDraggingInfo.NSDragOperationCopy.intValue()));
        }
        return new NSUInteger((long)(NSDraggingInfo.NSDragOperationCopy.intValue() | NSDraggingInfo.NSDragOperationDelete.intValue()));
    }

    public boolean acceptDrop(NSTableView view, Path destination, NSDraggingInfo info) {
        NSArray elements;
        NSObject o;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Accept drop for destination %s", destination));
        }
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null && (o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type")) != null && o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
            elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
            for (int i = 0; i < elements.count().intValue(); ++i) {
                if (!Scheme.isURL((String)elements.objectAtIndex(new NSUInteger((long)i)).toString())) continue;
                this.controller.mount(HostParser.parse((String)elements.objectAtIndex(new NSUInteger((long)i)).toString()));
                return true;
            }
        }
        if (this.controller.isMounted()) {
            if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null) {
                o = info.draggingPasteboard().propertyListForType("NSFilenamesPboardType");
                if (o != null && o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
                    elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                    ArrayList<TransferItem> roots = new ArrayList<TransferItem>();
                    for (int i = 0; i < elements.count().intValue(); ++i) {
                        Local local = LocalFactory.get((String)elements.objectAtIndex(new NSUInteger((long)i)).toString());
                        roots.add(new TransferItem(new Path(destination, local.getName(), local.isDirectory() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file)), local));
                    }
                    this.controller.transfer((Transfer)new UploadTransfer(this.controller.getSession().getHost(), roots));
                    return true;
                }
                return false;
            }
            List pasteboards = PathPasteboardFactory.allPasteboards();
            for (PathPasteboard pasteboard : pasteboards) {
                HashMap<Path, Path> files;
                if (pasteboard.isEmpty()) continue;
                if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue() || pasteboard.getBookmark().compareTo(this.controller.getSession().getHost()) != 0) {
                    files = new HashMap<Path, Path>();
                    for (Path file : pasteboard) {
                        files.put(file, new Path(destination, file.getName(), file.getType()));
                    }
                    Host target = this.controller.getSession().getHost();
                    this.controller.transfer((Transfer)new CopyTransfer(pasteboard.getBookmark(), target, files), new ArrayList<Path>(files.values()), false);
                } else {
                    files = new HashMap();
                    for (Path next : pasteboard) {
                        Path renamed = new Path(destination, next.getName(), next.getType());
                        files.put(next, renamed);
                    }
                    new MoveController(this.controller).rename(files);
                }
                pasteboard.clear();
            }
            return true;
        }
        return false;
    }

    public NSUInteger validateDrop(NSTableView view, Path destination, NSInteger row, NSDraggingInfo info) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validate drop for destination %s", destination));
        }
        if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"Apple URL pasteboard type")) != null) {
            NSObject o = info.draggingPasteboard().propertyListForType("Apple URL pasteboard type");
            if (o != null) {
                if (o.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
                    NSArray elements = (NSArray)Rococoa.cast((ObjCObject)o, NSArray.class);
                    for (int i = 0; i < elements.count().intValue(); ++i) {
                        if (Scheme.isURL((String)elements.objectAtIndex(new NSUInteger((long)i)).toString())) {
                            view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
                            return NSDraggingInfo.NSDragOperationCopy;
                        }
                        log.warn((Object)String.format("Protocol not supported for URL %s", elements.objectAtIndex(new NSUInteger((long)i)).toString()));
                    }
                }
            } else {
                log.warn((Object)"URL dragging pasteboard is empty.");
            }
        }
        if (this.controller.isMounted()) {
            if (null == destination) {
                log.warn((Object)"Dragging destination is null.");
                return NSDraggingInfo.NSDragOperationNone;
            }
            Touch feature = (Touch)this.controller.getSession().getFeature(Touch.class);
            if (!feature.isSupported(destination)) {
                return NSDraggingInfo.NSDragOperationNone;
            }
            if (info.draggingPasteboard().availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null) {
                this.setDropRowAndDropOperation(view, destination, row);
                return NSDraggingInfo.NSDragOperationCopy;
            }
            for (Path next : this.controller.getPasteboard()) {
                if (destination.equals((Object)next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (next.isDirectory() && destination.isChild(next)) {
                    return NSDraggingInfo.NSDragOperationNone;
                }
                if (!next.isFile() || !next.getParent().equals((Object)destination)) continue;
                return NSDraggingInfo.NSDragOperationNone;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Drag operation mask is %d", info.draggingSourceOperationMask().intValue()));
            }
            this.setDropRowAndDropOperation(view, destination, row);
            List pasteboards = PathPasteboardFactory.allPasteboards();
            for (PathPasteboard pasteboard : pasteboards) {
                if (pasteboard.isEmpty()) continue;
                if (pasteboard.getBookmark().compareTo(this.controller.getSession().getHost()) == 0) {
                    if (info.draggingSourceOperationMask().intValue() == NSDraggingInfo.NSDragOperationCopy.intValue()) {
                        return NSDraggingInfo.NSDragOperationCopy;
                    }
                    for (Path file : pasteboard) {
                        if (((Move)this.controller.getSession().getFeature(Move.class)).isSupported(file, destination)) continue;
                        return NSDraggingInfo.NSDragOperationNone;
                    }
                    return NSDraggingInfo.NSDragOperationMove;
                }
                return NSDraggingInfo.NSDragOperationCopy;
            }
        }
        return NSDraggingInfo.NSDragOperationNone;
    }

    private void setDropRowAndDropOperation(NSTableView view, Path destination, NSInteger row) {
        if (destination.equals((Object)this.controller.workdir())) {
            log.debug((Object)"setDropRowAndDropOperation:-1");
            view.setDropRow(new NSInteger(-1L), NSTableView.NSTableViewDropOn);
        } else if (destination.isDirectory()) {
            log.debug((Object)("setDropRowAndDropOperation:" + row.intValue()));
            view.setDropRow(row, NSTableView.NSTableViewDropOn);
        }
    }

    public boolean writeItemsToPasteBoard(NSTableView view, List<Path> selected, NSPasteboard pboard) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write items to pasteboard %s", pboard));
        }
        if (this.controller.isMounted() && selected.size() > 0) {
            NSMutableArray fileTypes = NSMutableArray.array();
            PathPasteboard pasteboard = this.controller.getPasteboard();
            for (Path f : selected) {
                if (f.isFile()) {
                    if (StringUtils.isNotEmpty((CharSequence)f.getExtension())) {
                        fileTypes.addObject((NSObject)NSString.stringWithString((String)f.getExtension()));
                    } else {
                        fileTypes.addObject((NSObject)NSString.stringWithString((String)"NSFileTypeRegular"));
                    }
                } else if (f.isDirectory()) {
                    fileTypes.addObject((NSObject)NSString.stringWithString((String)"'fldr'"));
                } else {
                    fileTypes.addObject((NSObject)NSString.stringWithString((String)"NSFileTypeUnknown"));
                }
                pasteboard.add((Object)f);
            }
            NSEvent event = NSApplication.sharedApplication().currentEvent();
            if (event != null) {
                NSPoint dragPosition = view.convertPoint_fromView(event.locationInWindow(), null);
                NSRect imageRect = new NSRect(new NSPoint(dragPosition.x.doubleValue() - 16.0, dragPosition.y.doubleValue() - 16.0), new NSSize(32.0, 32.0));
                view.dragPromisedFilesOfTypes((NSArray)fileTypes, imageRect, this.id(), true, event);
                return true;
            }
        }
        return false;
    }

    public void draggedImage_beganAt(NSImage image, NSPoint point) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("draggedImage_beganAt:" + point));
        }
    }

    public void draggedImage_endedAt_operation(NSImage image, NSPoint point, NSUInteger operation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("draggedImage_endedAt_operation:" + operation));
        }
        PathPasteboard pasteboard = this.controller.getPasteboard();
        if (NSDraggingInfo.NSDragOperationDelete.intValue() == operation.intValue()) {
            new DeleteController(this.controller).delete((List<Path>)pasteboard);
        }
        pasteboard.clear();
    }

    public void draggedImage_movedTo(NSImage image, NSPoint point) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("draggedImage_movedTo:" + point));
        }
    }

    public NSArray namesOfPromisedFilesDroppedAtDestination(NSURL url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Return names of promised files dropped at %s", url));
        }
        NSMutableArray promisedDragNames = NSMutableArray.array();
        if (null != url) {
            boolean dock;
            Local destination = LocalFactory.get((String)url.path());
            PathPasteboard pasteboard = this.controller.getPasteboard();
            ArrayList<TransferItem> downloads = new ArrayList<TransferItem>();
            for (Path p : pasteboard) {
                downloads.add(new TransferItem(p, LocalFactory.get((Local)destination, (String)p.getName())));
                promisedDragNames.addObject((NSObject)NSString.stringWithString((String)p.getName()));
            }
            if (downloads.size() == 1) {
                Local file;
                if (((TransferItem)downloads.iterator().next()).remote.isFile() && !(file = ((TransferItem)downloads.iterator().next()).local).exists()) {
                    try {
                        LocalTouchFactory.get().touch(file);
                        IconServiceFactory.get().set(file, new TransferStatus());
                    }
                    catch (AccessDeniedException e) {
                        log.warn((Object)String.format("Failure creating file %s %s", file, e.getMessage()));
                    }
                }
                if (((TransferItem)downloads.iterator().next()).remote.isDirectory() && !(file = ((TransferItem)downloads.iterator().next()).local).exists()) {
                    try {
                        file.mkdir();
                    }
                    catch (AccessDeniedException e) {
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dock = destination.equals((Object)LocalFactory.get((String)"~/Library/Caches/TemporaryItems"))) {
                for (Path p : pasteboard) {
                    this.controller.edit(p);
                }
            } else {
                DownloadTransfer transfer = new DownloadTransfer(this.controller.getSession().getHost(), downloads);
                this.controller.transfer((Transfer)transfer, Collections.emptyList());
            }
            pasteboard.clear();
        }
        return promisedDragNames;
    }

    private static final class Item {
        private final Path file;
        private final String column;

        public Item(Path file, String column) {
            this.file = file;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (this.column != null ? !this.column.equals(item.column) : item.column != null) {
                return false;
            }
            return !(this.file != null ? !this.file.equals((Object)item.file) : item.file != null);
        }

        public int hashCode() {
            int result = this.file != null ? this.file.hashCode() : 0;
            result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Item{");
            sb.append("file=").append(this.file);
            sb.append(", column='").append(this.column).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

