/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.datasource;

import ch.cyberduck.binding.OutlineDataSource;
import ch.cyberduck.binding.application.NSOutlineView;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNumber;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.NSObjectPathReference;
import ch.cyberduck.core.NSObjectTransferItemReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.TransferWorkerBackgroundAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.TransferPromptFilterWorker;
import ch.cyberduck.core.worker.TransferPromptListWorker;
import ch.cyberduck.core.worker.TransferWorker;
import ch.cyberduck.ui.cocoa.controller.TransferPromptController;
import ch.cyberduck.ui.cocoa.datasource.TableCellAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class TransferPromptDataSource
extends OutlineDataSource {
    private static final Logger log = Logger.getLogger(TransferPromptDataSource.class);
    private final TransferPromptController controller;
    private final SessionPool source;
    private final SessionPool destination;
    private final Transfer transfer;
    private TransferAction action;
    private final Cache<TransferItem> cache;
    protected final Map<TransferItem, Boolean> selected = new HashMap<TransferItem, Boolean>();
    protected Map<TransferItem, TransferStatus> status = new HashMap<TransferItem, TransferStatus>();

    public TransferPromptDataSource(TransferPromptController c, SessionPool source, SessionPool destination, Transfer transfer, Cache<TransferItem> cache) {
        this.controller = c;
        this.source = source;
        this.destination = destination;
        this.transfer = transfer;
        this.cache = cache;
        this.action = TransferAction.forName((String)PreferencesFactory.get().getProperty(String.format("queue.prompt.%s.action.default", transfer.getType().name())));
    }

    public void setAction(TransferAction action) {
        this.action = action;
        this.filter();
    }

    public boolean isSelected(TransferItem file) {
        if (this.selected.containsKey(file)) {
            return this.selected.get(file);
        }
        return true;
    }

    public void setSelected(TransferItem file, boolean state) {
        this.selected.put(file, state);
    }

    protected AttributedList<TransferItem> get(TransferItem directory) {
        return this.cache.get((Referenceable)directory);
    }

    public TransferStatus getStatus(TransferItem file) {
        if (!this.status.containsKey(file)) {
            log.warn((Object)String.format("Unknown transfer status for %s", file));
            return new TransferStatus();
        }
        return this.status.get(file);
    }

    protected AttributedList<TransferItem> children(final TransferItem directory) {
        if (null == directory) {
            if (!this.cache.isCached(null)) {
                this.cache.put(null, new AttributedList((Iterable)this.transfer.getRoots()));
                this.filter();
            }
        } else if (!this.cache.isCached((Referenceable)directory)) {
            this.controller.background((BackgroundAction)new TransferWorkerBackgroundAction((Controller)this.controller, this.source, this.destination, (TransferWorker)new TransferPromptListWorker(this.transfer, directory.remote, directory.local, this.controller){

                public void cleanup(List<TransferItem> list) {
                    TransferPromptDataSource.this.cache.put((Referenceable)directory, new AttributedList(list));
                    TransferPromptDataSource.this.filter();
                }
            }, (ProgressListener)this.controller, (TranscriptListener)this.controller));
        }
        return this.get(directory);
    }

    private void filter() {
        this.controller.background((BackgroundAction)new TransferWorkerBackgroundAction((Controller)this.controller, this.source, this.destination, (TransferWorker)new TransferPromptFilterWorker(this.transfer, this.action, this.cache, this.controller){

            public void cleanup(Map<TransferItem, TransferStatus> accepted) {
                TransferPromptDataSource.this.status = accepted;
                TransferPromptDataSource.this.controller.reload();
            }
        }, (ProgressListener)this.controller, (TranscriptListener)this.controller));
    }

    protected NSObject objectValueForItem(TransferItem file, String identifier) {
        TransferStatus status = this.getStatus(file);
        if (identifier.equals(Column.include.name())) {
            if (status.isRejected()) {
                return NSNumber.numberWithBoolean((boolean)false);
            }
            return NSNumber.numberWithBoolean((boolean)this.isSelected(file));
        }
        if (identifier.equals(Column.filename.name())) {
            return NSAttributedString.attributedStringWithAttributes((String)file.remote.getName(), (NSDictionary)TableCellAttributes.browserFontLeftAlignment());
        }
        if (identifier.equals(Column.size.name())) {
            return NSAttributedString.attributedStringWithAttributes((String)SizeFormatterFactory.get().format(status.getLength()), (NSDictionary)TableCellAttributes.browserFontRightAlignment());
        }
        if (identifier.equals(Column.warning.name())) {
            if (file.remote.isFile() && status.getLength() == 0L) {
                return (NSObject)IconCacheFactory.get().iconNamed("alert.tiff");
            }
            return null;
        }
        throw new IllegalArgumentException(String.format("Unknown identifier %s", identifier));
    }

    public void outlineView_setObjectValue_forTableColumn_byItem(NSOutlineView outlineView, NSObject value, NSTableColumn tableColumn, NSObject item) {
        String identifier = tableColumn.identifier();
        if (identifier.equals(Column.include.name())) {
            TransferItem file = (TransferItem)this.cache.lookup((CacheReference)new NSObjectTransferItemReference(item));
            int state = ((NSNumber)Rococoa.cast((ObjCObject)value, NSNumber.class)).intValue();
            this.setSelected(file, state == 1);
        }
    }

    public boolean outlineView_isItemExpandable(NSOutlineView view, NSObject item) {
        return ((TransferItem)this.cache.lookup((CacheReference)new NSObjectTransferItemReference((NSObject)item))).remote.isDirectory();
    }

    public NSInteger outlineView_numberOfChildrenOfItem(NSOutlineView view, NSObject item) {
        return new NSInteger((long)this.children(null == item ? null : (TransferItem)this.cache.lookup((CacheReference)new NSObjectTransferItemReference(item))).size());
    }

    public NSObject outlineView_child_ofItem(NSOutlineView view, NSInteger index, NSObject item) {
        AttributedList<TransferItem> children = this.get(null == item ? null : (TransferItem)this.cache.lookup((CacheReference)new NSObjectTransferItemReference(item)));
        return NSObjectPathReference.get((Path)((TransferItem)children.get((int)index.intValue())).remote);
    }

    public NSObject outlineView_objectValueForTableColumn_byItem(NSOutlineView view, NSTableColumn tableColumn, NSObject item) {
        return this.objectValueForItem((TransferItem)this.cache.lookup((CacheReference)new NSObjectTransferItemReference(item)), tableColumn.identifier());
    }

    public static enum Column {
        include,
        warning,
        filename,
        size;

    }
}

