/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.HistoryMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import ch.cyberduck.ui.cocoa.delegate.RendezvousMenuDelegate;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class BookmarkMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static final Logger log = Logger.getLogger(BookmarkMenuDelegate.class);
    private static final int BOOKMARKS_INDEX = 8;
    private final Preferences preferences = PreferencesFactory.get();
    private final AbstractHostCollection collection;
    private final int index;
    private final MenuCallback callback;
    private final NSMenu historyMenu = NSMenu.menu();
    private final HistoryMenuDelegate historyMenuDelegate;
    private final NSMenu rendezvousMenu = NSMenu.menu();
    private final RendezvousMenuDelegate rendezvousMenuDelegate;

    public BookmarkMenuDelegate() {
        this(new HistoryMenuDelegate(), new RendezvousMenuDelegate());
    }

    public BookmarkMenuDelegate(HistoryMenuDelegate history, RendezvousMenuDelegate rendezvous) {
        this(new MenuCallback(){

            @Override
            public void selected(NSMenuItem sender) {
                MainController.newDocument().mount(BookmarkCollection.defaultCollection().lookup(sender.representedObject()));
            }
        }, history, rendezvous);
    }

    public BookmarkMenuDelegate(MenuCallback callback) {
        this(callback, new HistoryMenuDelegate(), new RendezvousMenuDelegate());
    }

    public BookmarkMenuDelegate(MenuCallback callback, HistoryMenuDelegate history, RendezvousMenuDelegate rendezvous) {
        this((AbstractHostCollection)BookmarkCollection.defaultCollection(), 8, callback, history, rendezvous);
    }

    public BookmarkMenuDelegate(AbstractHostCollection collection, int index, MenuCallback callback, HistoryMenuDelegate history, RendezvousMenuDelegate rendezvous) {
        super(collection);
        this.collection = collection;
        this.index = index;
        this.historyMenuDelegate = history;
        this.rendezvousMenuDelegate = rendezvous;
        this.historyMenu.setDelegate(this.historyMenuDelegate.id());
        this.rendezvousMenu.setDelegate(this.rendezvousMenuDelegate.id());
        this.callback = callback;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        return new NSInteger((long)(this.collection.size() + this.index + 3));
    }

    @Override
    public Host itemForIndex(NSInteger row) {
        return (Host)this.collection.get(row.intValue() - (this.index + 3));
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger row, boolean cancel) {
        if (row.intValue() == this.index) {
            item.setEnabled(true);
            item.setTitle(LocaleFactory.get().localize("History", "Main"));
            item.setImage((NSImage)IconCacheFactory.get().iconNamed("history.tiff", Integer.valueOf(16)));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"historyMenuClicked:"));
            item.setSubmenu(this.historyMenu);
        }
        if (row.intValue() == this.index + 1) {
            item.setEnabled(true);
            item.setTitle(LocaleFactory.get().localize("Bonjour", "Main"));
            item.setImage((NSImage)IconCacheFactory.get().iconNamed("rendezvous.tiff", Integer.valueOf(16)));
            item.setSubmenu(this.rendezvousMenu);
        }
        if (row.intValue() == this.index + 2) {
            menu.removeItemAtIndex(row);
            menu.insertItem_atIndex(this.seperator(), row);
        }
        if (row.intValue() > this.index + 2) {
            Host h = this.itemForIndex(row);
            item.setTitle(BookmarkNameProvider.toString((Host)h));
            item.setTarget(this.id());
            item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(this.preferences.getInteger("bookmark.menu.icon.size"))));
            item.setAction(this.getDefaultAction());
            item.setRepresentedObject(h.getUuid());
        }
        return super.menuUpdateItemAtIndex(menu, item, row, cancel);
    }

    public void bookmarkMenuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Menu item clicked %s", sender));
        }
        this.callback.selected(sender);
    }

    public void historyMenuClicked(NSMenuItem sender) {
        ApplicationLauncherFactory.get().open(HistoryCollection.defaultCollection().getFolder());
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"bookmarkMenuItemClicked:");
    }
}

