/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class EditMenuDelegate
extends AbstractMenuDelegate {
    private String extension = null;

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        Path file = this.getEditable();
        int count = null == file ? EditorFactory.instance().getEditors().size() : EditorFactory.instance().getEditors(file.getName()).size();
        if (0 == count) {
            return new NSInteger(1L);
        }
        return new NSInteger((long)count);
    }

    protected abstract Path getEditable();

    @Override
    protected boolean isPopulated() {
        Path selected = this.getEditable();
        if (selected != null && Objects.equals(this.extension, selected.getExtension())) {
            return true;
        }
        this.extension = selected != null ? selected.getExtension() : null;
        return false;
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        Path selected = this.getEditable();
        List editors = null == selected ? EditorFactory.instance().getEditors() : EditorFactory.instance().getEditors(selected.getName());
        if (editors.size() == 0) {
            item.setTitle(LocaleFactory.localizedString((String)"No external editor available"));
            return false;
        }
        Application application = (Application)editors.get(index.intValue());
        item.setRepresentedObject(application.getIdentifier());
        String editor = ((Application)editors.get(index.intValue())).getName();
        if (StringUtils.isBlank((CharSequence)editor)) {
            item.setTitle(LocaleFactory.localizedString((String)"Unknown"));
        } else {
            item.setTitle(editor);
        }
        if (null != selected && application.getIdentifier().equalsIgnoreCase(EditorFactory.instance().getEditor(selected.getName()).getIdentifier())) {
            this.setShortcut(item, this.getKeyEquivalent(), this.getModifierMask());
        } else {
            this.clearShortcut(item);
        }
        item.setImage((NSImage)IconCacheFactory.get().applicationIcon(application, Integer.valueOf(16)));
        item.setAction(Foundation.selector((String)"editMenuClicked:"));
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    @Override
    protected String getKeyEquivalent() {
        return "k";
    }

    @Override
    protected int getModifierMask() {
        return 0x100000;
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"editButtonClicked:");
    }
}

