/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import java.util.Date;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class HistoryMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static final Logger log = Logger.getLogger(HistoryMenuDelegate.class);
    protected static final NSDictionary TIMESTAMP_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.userFontOfSize((double)NSFont.smallSystemFontSize()), NSColor.darkGrayColor(), BundleController.PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor", "NSParagraphStyle"}));
    private final AbstractHostCollection collection = HistoryCollection.defaultCollection();
    private final MenuCallback callback;
    private final Preferences preferences = PreferencesFactory.get();

    public HistoryMenuDelegate() {
        this(new MenuCallback(){

            @Override
            public void selected(NSMenuItem sender) {
                MainController.newDocument().mount(HistoryCollection.defaultCollection().lookup(sender.representedObject()));
            }
        });
    }

    public HistoryMenuDelegate(MenuCallback callback) {
        this((AbstractHostCollection)HistoryCollection.defaultCollection(), callback);
    }

    public HistoryMenuDelegate(AbstractHostCollection collection, MenuCallback callback) {
        super(collection);
        this.callback = callback;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        if (this.collection.size() > 0) {
            return new NSInteger((long)(this.collection.size() * 2 + 2));
        }
        return new NSInteger(1L);
    }

    @Override
    public Host itemForIndex(NSInteger index) {
        return (Host)this.collection.get(index.intValue() / 2);
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger row, boolean cancel) {
        int size = this.collection.size();
        if (size == 0) {
            item.setTitle(LocaleFactory.localizedString((String)"No recently connected servers available"));
            item.setTarget(null);
            item.setAction(null);
            item.setImage(null);
            item.setEnabled(false);
            return false;
        }
        if (row.intValue() < size * 2) {
            boolean label = row.intValue() % 2 == 0;
            Host h = this.itemForIndex(row);
            if (label) {
                item.setTitle(BookmarkNameProvider.toString((Host)h));
                item.setTarget(this.id());
                item.setAction(this.getDefaultAction());
                item.setRepresentedObject(h.getUuid());
                item.setEnabled(true);
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(this.preferences.getInteger("bookmark.menu.icon.size"))));
            } else {
                Date timestamp = h.getTimestamp();
                if (null != timestamp) {
                    item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)UserDateFormatterFactory.get().getLongFormat(timestamp.getTime()), (NSDictionary)TIMESTAMP_FONT_ATTRIBUTES));
                } else {
                    item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)LocaleFactory.localizedString((String)"Unknown"), (NSDictionary)TIMESTAMP_FONT_ATTRIBUTES));
                }
            }
        } else if (row.intValue() == size * 2) {
            menu.removeItemAtIndex(row);
            menu.insertItem_atIndex(this.seperator(), row);
        } else if (row.intValue() == size * 2 + 1) {
            item.setTitle(LocaleFactory.localizedString((String)"Clear Menu"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"clearMenuItemClicked:"));
            item.setEnabled(true);
        }
        return super.menuUpdateItemAtIndex(menu, item, row, cancel);
    }

    public void menuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Menu item clicked %s", sender));
        }
        this.callback.selected(sender);
    }

    public void clearMenuItemClicked(NSMenuItem sender) {
        this.collection.clear();
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"menuItemClicked:");
    }
}

