/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.ui.cocoa.delegate.URLMenuDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class OpenURLMenuDelegate
extends URLMenuDelegate {
    @Override
    protected String getKeyEquivalent() {
        return "b";
    }

    @Override
    protected int getModifierMask() {
        return 0x120000;
    }

    @Override
    protected List<DescriptiveUrl> getURLs(Path selected) {
        DistributionConfiguration feature;
        ArrayList<DescriptiveUrl> list = new ArrayList<DescriptiveUrl>();
        SessionPool pool = this.getSession();
        UrlProvider provider = (UrlProvider)pool.getFeature(UrlProvider.class);
        if (provider != null) {
            list.addAll((Collection<DescriptiveUrl>)provider.toUrl(selected).filter(new DescriptiveUrl.Type[]{DescriptiveUrl.Type.http, DescriptiveUrl.Type.cname, DescriptiveUrl.Type.cdn, DescriptiveUrl.Type.signed, DescriptiveUrl.Type.authenticated, DescriptiveUrl.Type.torrent}));
        }
        if ((feature = (DistributionConfiguration)pool.getFeature(DistributionConfiguration.class)) != null) {
            list.addAll((Collection<DescriptiveUrl>)feature.toUrl(selected));
        }
        return list;
    }

    @Override
    public void handle(List<DescriptiveUrl> selected) {
        for (DescriptiveUrl url : selected) {
            BrowserLauncherFactory.get().open(url.getUrl());
        }
    }
}

