/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.quicklook;

import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewItem;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanel;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanelDataSource;
import ch.cyberduck.ui.cocoa.quicklook.QuickLook;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSInteger;

public final class QuartzQuickLook
implements QuickLook {
    private static final Logger log = Logger.getLogger(QuartzQuickLook.class);
    private final List<QLPreviewItem> previews = new ArrayList<QLPreviewItem>();
    private final QLPreviewPanel panel;
    private final QLPreviewPanelDataSource model = new QLPreviewPanelDataSource(){

        @Override
        public NSInteger numberOfPreviewItemsInPreviewPanel(QLPreviewPanel panel) {
            return new NSInteger((long)QuartzQuickLook.this.previews.size());
        }

        @Override
        public ID previewPanel_previewItemAtIndex(QLPreviewPanel panel, int index) {
            return ((QLPreviewItem)((Object)QuartzQuickLook.this.previews.get(index))).id();
        }
    };

    public QuartzQuickLook() {
        this.panel = QLPreviewPanel.sharedPreviewPanel();
    }

    @Override
    public void select(List<Local> files) {
        this.previews.clear();
        for (final Local selected : files) {
            this.previews.add(new QLPreviewItem(){

                @Override
                public NSURL previewItemURL() {
                    return NSURL.fileURLWithPath((String)selected.getAbsolute());
                }

                @Override
                public String previewItemTitle() {
                    return selected.getDisplayName();
                }
            });
        }
    }

    @Override
    public boolean isOpen() {
        return QLPreviewPanel.sharedPreviewPanelExists() && this.panel.isVisible();
    }

    @Override
    public void willBeginQuickLook() {
        this.panel.setDataSource(this.model.id());
    }

    @Override
    public void open() {
        this.panel.makeKeyAndOrderFront(null);
        if (null == this.panel.dataSource()) {
            log.warn((Object)"Do not reload data yet because datasource is not yet setup. Focus has probably changed to another application since");
            return;
        }
        this.panel.reloadData();
    }

    @Override
    public void close() {
        this.panel.setDataSource(null);
        this.panel.close();
    }

    @Override
    public void didEndQuickLook() {
        this.previews.clear();
    }
}

