/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.toolbar;

import ch.cyberduck.binding.application.NSPasteboard;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Archive;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.TerminalServiceFactory;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.ui.browser.UploadTargetFinder;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.quicklook.QuickLook;
import ch.cyberduck.ui.cocoa.quicklook.QuickLookFactory;
import ch.cyberduck.ui.cocoa.toolbar.BrowserToolbarFactory;
import ch.cyberduck.ui.cocoa.toolbar.ToolbarValidator;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;

public class BrowserToolbarValidator
implements ToolbarValidator {
    private final QuickLook quicklook = QuickLookFactory.get();
    private final BrowserController controller;

    public BrowserToolbarValidator(BrowserController controller) {
        this.controller = controller;
    }

    @Override
    public boolean validate(NSToolbarItem item) {
        String identifier = item.itemIdentifier();
        switch (BrowserToolbarFactory.BrowserToolbarItem.valueOf(identifier)) {
            case disconnect: {
                if (this.controller.isActivityRunning()) {
                    item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.stop.label());
                    item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.stop.label());
                    item.setToolTip(BrowserToolbarFactory.BrowserToolbarItem.stop.tooltip());
                    item.setImage(BrowserToolbarFactory.BrowserToolbarItem.stop.image());
                    break;
                }
                item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.disconnect.label());
                item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.disconnect.label());
                item.setToolTip(BrowserToolbarFactory.BrowserToolbarItem.disconnect.tooltip());
                item.setImage(BrowserToolbarFactory.BrowserToolbarItem.disconnect.image());
                break;
            }
            case archive: {
                Path selected = this.controller.getSelectedPath();
                if (null == selected) break;
                if (Archive.isArchive((String)selected.getName())) {
                    item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.unarchive.label());
                    item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.unarchive.label());
                    item.setAction(BrowserToolbarFactory.BrowserToolbarItem.unarchive.action());
                    break;
                }
                item.setLabel(BrowserToolbarFactory.BrowserToolbarItem.archive.label());
                item.setPaletteLabel(BrowserToolbarFactory.BrowserToolbarItem.archive.label());
                item.setAction(BrowserToolbarFactory.BrowserToolbarItem.archive.action());
                break;
            }
            case encoding: {
                NSPopUpButton popup = (NSPopUpButton)Rococoa.cast((ObjCObject)item.view(), NSPopUpButton.class);
                popup.selectItemAtIndex(popup.indexOfItemWithRepresentedObject(this.controller.isMounted() ? this.controller.getSession().getHost().getEncoding() : PreferencesFactory.get().getProperty("browser.charset.encoding")));
            }
        }
        return this.validate(item.action());
    }

    @Override
    public boolean validate(Selector action) {
        if (action.equals((Object)Foundation.selector((String)"cut:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"copy:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"paste:"))) {
            if (this.isBrowser() && this.controller.isMounted()) {
                if (this.controller.getPasteboard().isEmpty()) {
                    NSObject o;
                    NSPasteboard pboard = NSPasteboard.generalPasteboard();
                    return pboard.availableTypeFromArray(NSArray.arrayWithObject((String)"NSFilenamesPboardType")) != null && (o = pboard.propertyListForType("NSFilenamesPboardType")) != null;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.encoding.action())) {
            return this.isBrowser();
        }
        if (action.equals((Object)Foundation.selector((String)"connectBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkTable().numberOfSelectedRows().intValue() == 1;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.addbookmark.action())) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsAdd();
            }
            return true;
        }
        if (action.equals((Object)Foundation.selector((String)"deleteBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsDelete() && this.controller.getBookmarkTable().selectedRow().intValue() != -1;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"duplicateBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsEdit() && this.controller.getBookmarkTable().numberOfSelectedRows().intValue() == 1;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"editBookmarkButtonClicked:"))) {
            if (this.isBookmarks()) {
                return this.controller.getBookmarkModel().getSource().allowsEdit() && this.controller.getBookmarkTable().numberOfSelectedRows().intValue() == 1;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.edit.action())) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                EditorFactory factory = EditorFactory.instance();
                for (Path s : this.controller.getSelectedPaths()) {
                    if (!this.controller.isEditable(s)) {
                        return false;
                    }
                    if (null != factory.getEditor(s.getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"editMenuClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                for (Path s : this.controller.getSelectedPaths()) {
                    if (this.controller.isEditable(s)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"searchButtonClicked:"))) {
            return this.controller.isMounted() || this.isBookmarks();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.quicklook.action())) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0) {
                Path selected = this.controller.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return selected.isFile();
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.webbrowser.action())) {
            return this.controller.isMounted();
        }
        if (action.equals((Object)Foundation.selector((String)"sendCustomCommandClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getFeature(Command.class) != null;
        }
        if (action.equals((Object)Foundation.selector((String)"gotoButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.info.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.newfolder.action())) {
            return this.isBrowser() && this.controller.isMounted() && ((Directory)this.controller.getSession().getFeature(Directory.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()));
        }
        if (action.equals((Object)Foundation.selector((String)"createEncryptedVaultButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getVault() != VaultRegistry.DISABLED && ((Directory)this.controller.getSession().getFeature(Directory.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()));
        }
        if (action.equals((Object)Foundation.selector((String)"createFileButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && ((Touch)this.controller.getSession().getFeature(Touch.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()));
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.upload.action())) {
            return this.isBrowser() && this.controller.isMounted() && ((Touch)this.controller.getSession().getFeature(Touch.class)).isSupported(new UploadTargetFinder(this.controller.workdir()).find(this.controller.getSelectedPath()));
        }
        if (action.equals((Object)Foundation.selector((String)"createSymlinkButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getFeature(Symlink.class) != null && this.controller.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector((String)"duplicateFileButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector((String)"renameFileButtonClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() == 1) {
                Path selected = this.controller.getSelectedPath();
                if (null == selected) {
                    return false;
                }
                return ((Move)this.controller.getSession().getFeature(Move.class)).isSupported(selected, selected);
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.delete.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"revertFileButtonClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() == 1) {
                return this.controller.getSession().getFeature(Versioning.class) != null;
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.reload.action())) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)Foundation.selector((String)"newBrowserButtonClicked:"))) {
            return this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.synchronize.action())) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)Foundation.selector((String)"downloadAsButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() == 1;
        }
        if (action.equals((Object)Foundation.selector((String)"downloadToButtonClicked:")) || action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.download.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"insideButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSelectionCount() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"upButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && !this.controller.workdir().isRoot();
        }
        if (action.equals((Object)Foundation.selector((String)"backButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getNavigation().getBack().size() > 1;
        }
        if (action.equals((Object)Foundation.selector((String)"forwardButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getNavigation().getForward().size() > 0;
        }
        if (action.equals((Object)Foundation.selector((String)"printDocument:"))) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.disconnect.action())) {
            if (this.isBrowser()) {
                if (!this.controller.isConnected()) {
                    return this.controller.isActivityRunning();
                }
                return this.controller.isConnected();
            }
            return false;
        }
        if (action.equals((Object)Foundation.selector((String)"gotofolderButtonClicked:"))) {
            return this.isBrowser() && this.controller.isMounted();
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.terminal.action())) {
            return this.isBrowser() && this.controller.isMounted() && this.controller.getSession().getHost().getProtocol().getType() == Protocol.Type.sftp && TerminalServiceFactory.get() != null;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.archive.action()) || action.equals((Object)Foundation.selector((String)"archiveMenuClicked:"))) {
            if (this.isBrowser() && this.controller.isMounted()) {
                if (this.controller.getSession().getFeature(Compress.class) == null) {
                    return false;
                }
                if (this.controller.getSelectionCount() > 0) {
                    for (Path s : this.controller.getSelectedPaths()) {
                        if (!s.isFile() || !Archive.isArchive((String)s.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        if (action.equals((Object)BrowserToolbarFactory.BrowserToolbarItem.unarchive.action())) {
            if (this.isBrowser() && this.controller.isMounted()) {
                if (this.controller.getSession().getFeature(Compress.class) == null) {
                    return false;
                }
                if (this.controller.getSelectionCount() > 0) {
                    for (Path s : this.controller.getSelectedPaths()) {
                        if (s.isDirectory()) {
                            return false;
                        }
                        if (Archive.isArchive((String)s.getName())) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected boolean isBrowser() {
        switch (this.controller.getSelectedTabView()) {
            case list: 
            case outline: {
                return true;
            }
        }
        return false;
    }

    protected boolean isBookmarks() {
        switch (this.controller.getSelectedTabView()) {
            case bookmarks: {
                return true;
            }
        }
        return false;
    }
}

