/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloudfront;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.analytics.QloudstatAnalyticsProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.DistributionUrlProvider;
import ch.cyberduck.core.cdn.features.Cname;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.cdn.features.Purge;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.iam.AmazonIdentityConfiguration;
import ch.cyberduck.core.iam.AmazonServiceExceptionMappingService;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3Session;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.cloudfront.AmazonCloudFront;
import com.amazonaws.services.cloudfront.AmazonCloudFrontClientBuilder;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.CustomHeaders;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.Distribution;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.DistributionSummary;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigResult;
import com.amazonaws.services.cloudfront.model.InvalidationBatch;
import com.amazonaws.services.cloudfront.model.InvalidationSummary;
import com.amazonaws.services.cloudfront.model.ItemSelection;
import com.amazonaws.services.cloudfront.model.ListDistributionsRequest;
import com.amazonaws.services.cloudfront.model.ListInvalidationsRequest;
import com.amazonaws.services.cloudfront.model.ListInvalidationsResult;
import com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.OriginProtocolPolicy;
import com.amazonaws.services.cloudfront.model.OriginSslProtocols;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.Paths;
import com.amazonaws.services.cloudfront.model.PriceClass;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.StreamingDistribution;
import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import com.amazonaws.services.cloudfront.model.StreamingLoggingConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateDistributionResult;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionResult;
import com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.utils.ServiceUtils;

public class CloudFrontDistributionConfiguration
implements DistributionConfiguration,
Purge,
Index,
DistributionLogging,
Cname {
    private static final Logger log = Logger.getLogger(CloudFrontDistributionConfiguration.class);
    protected final S3Session session;
    private final ClientConfiguration configuration;
    private final PathContainerService containerService = new PathContainerService();
    private final Map<Path, ch.cyberduck.core.cdn.Distribution> cache = new HashMap<Path, ch.cyberduck.core.cdn.Distribution>();
    private final Preferences preferences = PreferencesFactory.get();
    private final S3LocationFeature locationFeature;

    public CloudFrontDistributionConfiguration(S3Session session) {
        this.session = session;
        int timeout = this.preferences.getInteger("connection.timeout.seconds") * 1000;
        this.configuration = new ClientConfiguration();
        this.configuration.setConnectionTimeout(timeout);
        this.configuration.setSocketTimeout(timeout);
        PreferencesUseragentProvider ua = new PreferencesUseragentProvider();
        this.configuration.setUserAgentPrefix(ua.get());
        this.configuration.setMaxErrorRetry(0);
        this.configuration.setMaxConnections(1);
        this.configuration.setUseGzip(this.preferences.getBoolean("http.compression.enable"));
        Proxy proxy = ProxyFactory.get().find(session.getHost());
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                this.configuration.setProxyHost(proxy.getHostname());
                this.configuration.setProxyPort(proxy.getPort());
            }
        }
        this.locationFeature = new S3LocationFeature(session);
    }

    private <T> T authenticated(Authenticated<T> run, LoginCallback prompt) throws BackgroundException {
        LoginOptions options = new LoginOptions().anonymous(false).publickey(false);
        try {
            KeychainLoginService login = new KeychainLoginService(prompt, PasswordStoreFactory.get());
            login.validate(this.session.getHost(), LocaleFactory.localizedString((String)"AWS Key Management Service", (String)"S3"), options);
            return run.call();
        }
        catch (LoginFailureException failure) {
            prompt.prompt(this.session.getHost(), this.session.getHost().getCredentials(), LocaleFactory.localizedString((String)"Login failed", (String)"Credentials"), failure.getMessage(), options);
            return this.authenticated(run, prompt);
        }
    }

    public String getName() {
        return LocaleFactory.localizedString((String)"Amazon CloudFront", (String)"S3");
    }

    public String getName(Distribution.Method method) {
        return this.getName();
    }

    public String getHostname() {
        return "cloudfront.amazonaws.com";
    }

    protected URI getOrigin(Path container, Distribution.Method method) {
        return URI.create(String.format("http://%s.%s", container.getName(), this.session.getHost().getProtocol().getDefaultHostname()));
    }

    public DescriptiveUrlBag toUrl(Path file) {
        if (this.cache.containsKey(this.containerService.getContainer(file))) {
            return new DistributionUrlProvider(this.cache.get(this.containerService.getContainer(file))).toUrl(file);
        }
        return DescriptiveUrlBag.empty();
    }

    public List<Distribution.Method> getMethods(Path container) {
        return Arrays.asList(ch.cyberduck.core.cdn.Distribution.DOWNLOAD, ch.cyberduck.core.cdn.Distribution.STREAMING);
    }

    public ch.cyberduck.core.cdn.Distribution read(Path file, final Distribution.Method method, LoginCallback prompt) throws BackgroundException {
        final Path container = this.containerService.getContainer(file);
        return this.authenticated(new Authenticated<ch.cyberduck.core.cdn.Distribution>(){

            @Override
            public ch.cyberduck.core.cdn.Distribution call() throws BackgroundException {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("List %s distributions", method));
                    }
                    AmazonCloudFront client = CloudFrontDistributionConfiguration.this.client(container);
                    if (method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
                        for (StreamingDistributionSummary d : client.listStreamingDistributions(new ListStreamingDistributionsRequest()).getStreamingDistributionList().getItems()) {
                            S3Origin config = d.getS3Origin();
                            if (config == null) continue;
                            URI origin = CloudFrontDistributionConfiguration.this.getOrigin(container, method);
                            if (!config.getDomainName().equals(origin.getHost())) continue;
                            ch.cyberduck.core.cdn.Distribution distribution = CloudFrontDistributionConfiguration.this.readStreamingDistribution(client, d, container, method);
                            CloudFrontDistributionConfiguration.this.cache.put(container, distribution);
                            return distribution;
                        }
                    } else if (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
                        for (DistributionSummary d : client.listDistributions(new ListDistributionsRequest()).getDistributionList().getItems()) {
                            for (Origin o : d.getOrigins().getItems()) {
                                S3OriginConfig config = o.getS3OriginConfig();
                                if (config == null) continue;
                                URI origin = CloudFrontDistributionConfiguration.this.getOrigin(container, method);
                                if (!o.getDomainName().equals(origin.getHost())) continue;
                                ch.cyberduck.core.cdn.Distribution distribution = CloudFrontDistributionConfiguration.this.readDownloadDistribution(client, d, container, method);
                                CloudFrontDistributionConfiguration.this.cache.put(container, distribution);
                                return distribution;
                            }
                        }
                    } else if (method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
                        for (DistributionSummary d : client.listDistributions(new ListDistributionsRequest()).getDistributionList().getItems()) {
                            for (Origin o : d.getOrigins().getItems()) {
                                CustomOriginConfig config = o.getCustomOriginConfig();
                                if (config == null) continue;
                                URI origin = CloudFrontDistributionConfiguration.this.getOrigin(container, method);
                                if (!o.getDomainName().equals(origin.getHost())) continue;
                                ch.cyberduck.core.cdn.Distribution distribution = CloudFrontDistributionConfiguration.this.readDownloadDistribution(client, d, container, method);
                                CloudFrontDistributionConfiguration.this.cache.put(container, distribution);
                                return distribution;
                            }
                        }
                    }
                    URI origin = CloudFrontDistributionConfiguration.this.getOrigin(container, method);
                    return new ch.cyberduck.core.cdn.Distribution(origin, method, false);
                }
                catch (AmazonClientException e) {
                    throw new AmazonServiceExceptionMappingService().map("Cannot read CDN configuration", e);
                }
            }
        }, prompt);
    }

    public void write(Path file, final ch.cyberduck.core.cdn.Distribution distribution, LoginCallback prompt) throws BackgroundException {
        final Path container = this.containerService.getContainer(file);
        this.authenticated(new Authenticated<Void>(){

            @Override
            public Void call() throws BackgroundException {
                try {
                    if (null == distribution.getId()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("No existing distribution found for method %s", distribution.getMethod()));
                        }
                        if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
                            distribution.setId(CloudFrontDistributionConfiguration.this.createStreamingDistribution(container, distribution).getId());
                        } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
                            distribution.setId(CloudFrontDistributionConfiguration.this.createDownloadDistribution(container, distribution).getId());
                        } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
                            distribution.setId(CloudFrontDistributionConfiguration.this.createCustomDistribution(container, distribution).getId());
                        }
                    } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD)) {
                        distribution.setEtag(CloudFrontDistributionConfiguration.this.updateDownloadDistribution(container, distribution).getETag());
                    } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.STREAMING)) {
                        distribution.setEtag(CloudFrontDistributionConfiguration.this.updateStreamingDistribution(container, distribution).getETag());
                    } else if (distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) || distribution.getMethod().equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN)) {
                        distribution.setEtag(CloudFrontDistributionConfiguration.this.updateCustomDistribution(container, distribution).getETag());
                    }
                }
                catch (AmazonClientException e) {
                    throw new AmazonServiceExceptionMappingService().map("Cannot write CDN configuration", e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Cannot write CDN configuration", (Throwable)e);
                }
                return null;
            }
        }, prompt);
    }

    public <T> T getFeature(Class<T> type, Distribution.Method method) {
        if ((type == Purge.class || type == Index.class) && (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.WEBSITE_CDN) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM))) {
            return (T)this;
        }
        if (type == DistributionLogging.class && (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM))) {
            return (T)this;
        }
        if (type == AnalyticsProvider.class && (method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.STREAMING) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM))) {
            return (T)new QloudstatAnalyticsProvider();
        }
        if (type == Cname.class) {
            return (T)this;
        }
        if (type == IdentityConfiguration.class) {
            return (T)new AmazonIdentityConfiguration(this.session.getHost());
        }
        return null;
    }

    public void invalidate(Path container, Distribution.Method method, List<Path> files, LoginCallback prompt) throws BackgroundException {
        try {
            ch.cyberduck.core.cdn.Distribution d = this.read(container, method, prompt);
            ArrayList<String> keys = new ArrayList<String>();
            for (Path file : files) {
                if (this.containerService.isContainer(file)) {
                    keys.add(String.format("%s*", String.valueOf('/')));
                    continue;
                }
                if (file.isDirectory()) {
                    keys.add(String.format("/%s*", this.containerService.getKey(file)));
                    continue;
                }
                keys.add(String.format("/%s", this.containerService.getKey(file)));
            }
            if (keys.isEmpty()) {
                log.warn((Object)"No keys selected for invalidation");
            } else {
                AmazonCloudFront client = this.client(container);
                client.createInvalidation(new CreateInvalidationRequest(d.getId(), new InvalidationBatch(new Paths().withItems(keys).withQuantity(Integer.valueOf(keys.size())), new AlphanumericRandomStringService().random())));
            }
        }
        catch (AmazonClientException e) {
            throw new AmazonServiceExceptionMappingService().map("Cannot write CDN configuration", e);
        }
    }

    private String readInvalidationStatus(AmazonCloudFront client, ch.cyberduck.core.cdn.Distribution distribution) throws BackgroundException {
        try {
            ListInvalidationsResult response;
            int pending = 0;
            int completed = 0;
            String marker = null;
            do {
                response = client.listInvalidations(new ListInvalidationsRequest(distribution.getId()).withMaxItems(String.valueOf(1000)).withMarker(marker));
                for (InvalidationSummary s : response.getInvalidationList().getItems()) {
                    if ("Completed".equals(s.getStatus())) {
                        ++completed;
                        continue;
                    }
                    ++pending;
                }
            } while ((marker = response.getInvalidationList().getNextMarker()) != null);
            if (pending > 0) {
                return MessageFormat.format(LocaleFactory.localizedString((String)"{0} invalidations in progress", (String)"S3"), pending);
            }
            if (completed > 0) {
                return MessageFormat.format(LocaleFactory.localizedString((String)"{0} invalidations completed", (String)"S3"), completed);
            }
            return LocaleFactory.localizedString((String)"None");
        }
        catch (AmazonClientException e) {
            throw new AmazonServiceExceptionMappingService().map("Cannot read CDN configuration", e);
        }
    }

    protected StreamingDistribution createStreamingDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Create new %s distribution", distribution.getMethod().toString()));
        }
        AmazonCloudFront client = this.client(container);
        URI origin = this.getOrigin(container, distribution.getMethod());
        String originId = String.format("%s-%s", this.preferences.getProperty("application.name"), new AlphanumericRandomStringService().random());
        StreamingDistributionConfig config = new StreamingDistributionConfig(new AlphanumericRandomStringService().random(), new S3Origin(origin.getHost(), ""), Boolean.valueOf(distribution.isEnabled())).withComment(originId).withTrustedSigners(new TrustedSigners().withEnabled(Boolean.valueOf(false)).withQuantity(Integer.valueOf(0))).withAliases(new Aliases().withItems(distribution.getCNAMEs()).withQuantity(Integer.valueOf(distribution.getCNAMEs().length)));
        String loggingTarget = ServiceUtils.generateS3HostnameForBucket((String)distribution.getLoggingContainer(), (boolean)false, (String)new S3Protocol().getDefaultHostname());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set logging target for %s to %s", distribution, loggingTarget));
        }
        config.setLogging(new StreamingLoggingConfig().withEnabled(Boolean.valueOf(distribution.isLogging())).withBucket(loggingTarget).withPrefix(this.preferences.getProperty("cloudfront.logging.prefix")));
        return client.createStreamingDistribution(new CreateStreamingDistributionRequest(config)).getStreamingDistribution();
    }

    protected Distribution createDownloadDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Create new %s distribution", distribution.getMethod().toString()));
        }
        AmazonCloudFront client = this.client(container);
        URI origin = this.getOrigin(container, distribution.getMethod());
        String originId = String.format("%s-%s", this.preferences.getProperty("application.name"), new AlphanumericRandomStringService().random());
        DistributionConfig config = new DistributionConfig(new AlphanumericRandomStringService().random(), Boolean.valueOf(distribution.isEnabled())).withComment(originId).withOrigins(new Origins().withQuantity(Integer.valueOf(1)).withItems(new Origin[]{new Origin().withId(originId).withCustomHeaders(new CustomHeaders().withQuantity(Integer.valueOf(0))).withOriginPath("").withDomainName(origin.getHost()).withS3OriginConfig(new S3OriginConfig().withOriginAccessIdentity(""))})).withPriceClass(PriceClass.PriceClass_All).withDefaultCacheBehavior(new DefaultCacheBehavior().withTargetOriginId(originId).withForwardedValues(new ForwardedValues().withQueryString(Boolean.valueOf(true)).withCookies(new CookiePreference().withForward(ItemSelection.All))).withViewerProtocolPolicy(ViewerProtocolPolicy.AllowAll).withMinTTL(Long.valueOf(0L)).withTrustedSigners(new TrustedSigners().withEnabled(Boolean.valueOf(false)).withQuantity(Integer.valueOf(0)))).withDefaultRootObject(distribution.getIndexDocument()).withAliases(new Aliases().withItems(distribution.getCNAMEs()).withQuantity(Integer.valueOf(distribution.getCNAMEs().length)));
        String loggingTarget = ServiceUtils.generateS3HostnameForBucket((String)distribution.getLoggingContainer(), (boolean)false, (String)new S3Protocol().getDefaultHostname());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set logging target for %s to %s", distribution, loggingTarget));
        }
        config.setLogging(new LoggingConfig().withEnabled(Boolean.valueOf(distribution.isLogging())).withIncludeCookies(Boolean.valueOf(true)).withBucket(loggingTarget).withPrefix(this.preferences.getProperty("cloudfront.logging.prefix")));
        return client.createDistribution(new CreateDistributionRequest(config)).getDistribution();
    }

    protected Distribution createCustomDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws BackgroundException {
        AmazonCloudFront client = this.client(container);
        int httpPort = 80;
        int httpsPort = 443;
        URI origin = this.getOrigin(container, distribution.getMethod());
        if (origin.getPort() != -1) {
            if (origin.getScheme().equals(Scheme.http.name())) {
                httpPort = origin.getPort();
            }
            if (origin.getScheme().equals(Scheme.https.name())) {
                httpsPort = origin.getPort();
            }
        }
        String originId = String.format("%s-%s", this.preferences.getProperty("application.name"), new AlphanumericRandomStringService().random());
        DistributionConfig config = new DistributionConfig(new AlphanumericRandomStringService().random(), Boolean.valueOf(distribution.isEnabled())).withComment(originId).withOrigins(new Origins().withQuantity(Integer.valueOf(1)).withItems(new Origin[]{new Origin().withId(originId).withDomainName(origin.getHost()).withCustomOriginConfig(new CustomOriginConfig().withHTTPPort(Integer.valueOf(httpPort)).withHTTPSPort(Integer.valueOf(httpsPort)).withOriginSslProtocols(new OriginSslProtocols().withQuantity(Integer.valueOf(2)).withItems(new String[]{"TLSv1.1", "TLSv1.2"})).withOriginProtocolPolicy(this.getPolicy(distribution.getMethod())))})).withPriceClass(PriceClass.PriceClass_All).withDefaultCacheBehavior(new DefaultCacheBehavior().withTargetOriginId(originId).withForwardedValues(new ForwardedValues().withQueryString(Boolean.valueOf(true)).withCookies(new CookiePreference().withForward(ItemSelection.All))).withViewerProtocolPolicy(ViewerProtocolPolicy.AllowAll).withMinTTL(Long.valueOf(0L)).withTrustedSigners(new TrustedSigners().withEnabled(Boolean.valueOf(false)).withQuantity(Integer.valueOf(0)))).withDefaultRootObject(distribution.getIndexDocument()).withAliases(new Aliases().withItems(distribution.getCNAMEs()).withQuantity(Integer.valueOf(distribution.getCNAMEs().length)));
        if (distribution.isLogging()) {
            String loggingTarget = ServiceUtils.generateS3HostnameForBucket((String)distribution.getLoggingContainer(), (boolean)false, (String)new S3Protocol().getDefaultHostname());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Set logging target for %s to %s", distribution, loggingTarget));
            }
            config.setLogging(new LoggingConfig().withEnabled(Boolean.valueOf(distribution.isLogging())).withIncludeCookies(Boolean.valueOf(true)).withBucket(loggingTarget).withPrefix(this.preferences.getProperty("cloudfront.logging.prefix")));
        }
        return client.createDistribution(new CreateDistributionRequest(config)).getDistribution();
    }

    protected UpdateDistributionResult updateDownloadDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws IOException, BackgroundException {
        URI origin = this.getOrigin(container, distribution.getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Update %s distribution with origin %s", distribution.getMethod().toString(), origin));
        }
        AmazonCloudFront client = this.client(container);
        GetDistributionConfigResult response = client.getDistributionConfig(new GetDistributionConfigRequest(distribution.getId()));
        DistributionConfig config = response.getDistributionConfig().withEnabled(Boolean.valueOf(distribution.isEnabled())).withDefaultRootObject(distribution.getIndexDocument()).withAliases(new Aliases().withItems(distribution.getCNAMEs()).withQuantity(Integer.valueOf(distribution.getCNAMEs().length)));
        if (distribution.isLogging()) {
            String loggingTarget = ServiceUtils.generateS3HostnameForBucket((String)distribution.getLoggingContainer(), (boolean)false, (String)new S3Protocol().getDefaultHostname());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Set logging target for %s to %s", distribution, loggingTarget));
            }
            config.setLogging(new LoggingConfig().withEnabled(Boolean.valueOf(distribution.isLogging())).withIncludeCookies(Boolean.valueOf(true)).withBucket(loggingTarget).withPrefix(this.preferences.getProperty("cloudfront.logging.prefix")));
        }
        return client.updateDistribution(new UpdateDistributionRequest(config, distribution.getId(), response.getETag()));
    }

    protected UpdateStreamingDistributionResult updateStreamingDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws IOException, BackgroundException {
        URI origin = this.getOrigin(container, distribution.getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Update %s distribution with origin %s", distribution.getMethod().toString(), origin));
        }
        AmazonCloudFront client = this.client(container);
        GetStreamingDistributionConfigResult response = client.getStreamingDistributionConfig(new GetStreamingDistributionConfigRequest(distribution.getId()));
        StreamingDistributionConfig config = response.getStreamingDistributionConfig().withEnabled(Boolean.valueOf(distribution.isEnabled())).withS3Origin(new S3Origin(origin.getHost(), "")).withAliases(new Aliases().withItems(distribution.getCNAMEs()).withQuantity(Integer.valueOf(distribution.getCNAMEs().length)));
        if (distribution.isLogging()) {
            String loggingTarget = ServiceUtils.generateS3HostnameForBucket((String)distribution.getLoggingContainer(), (boolean)false, (String)new S3Protocol().getDefaultHostname());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Set logging target for %s to %s", distribution, loggingTarget));
            }
            config.setLogging(new StreamingLoggingConfig().withEnabled(Boolean.valueOf(distribution.isLogging())).withBucket(loggingTarget).withPrefix(this.preferences.getProperty("cloudfront.logging.prefix")));
        }
        return client.updateStreamingDistribution(new UpdateStreamingDistributionRequest(config, distribution.getId(), response.getETag()));
    }

    protected UpdateDistributionResult updateCustomDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws IOException, BackgroundException {
        URI origin = this.getOrigin(container, distribution.getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Update %s distribution with origin %s", distribution.getMethod().toString(), origin));
        }
        AmazonCloudFront client = this.client(container);
        GetDistributionConfigResult response = client.getDistributionConfig(new GetDistributionConfigRequest(distribution.getId()));
        DistributionConfig config = response.getDistributionConfig().withEnabled(Boolean.valueOf(distribution.isEnabled())).withDefaultRootObject(distribution.getIndexDocument() != null ? distribution.getIndexDocument() : "").withAliases(new Aliases().withItems(distribution.getCNAMEs()).withQuantity(Integer.valueOf(distribution.getCNAMEs().length)));
        String loggingTarget = ServiceUtils.generateS3HostnameForBucket((String)distribution.getLoggingContainer(), (boolean)false, (String)new S3Protocol().getDefaultHostname());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set logging target for %s to %s", distribution, loggingTarget));
        }
        config.setLogging(new LoggingConfig().withEnabled(Boolean.valueOf(distribution.isLogging())).withIncludeCookies(Boolean.valueOf(true)).withBucket(loggingTarget).withPrefix(this.preferences.getProperty("cloudfront.logging.prefix")));
        return client.updateDistribution(new UpdateDistributionRequest(config, distribution.getId(), response.getETag()));
    }

    protected void deleteDownloadDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws IOException, BackgroundException {
        URI origin = this.getOrigin(container, distribution.getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Update %s distribution with origin %s", distribution.getMethod().toString(), origin));
        }
        AmazonCloudFront client = this.client(container);
        client.deleteDistribution(new DeleteDistributionRequest(distribution.getId(), distribution.getEtag()));
    }

    protected void deleteStreamingDistribution(Path container, ch.cyberduck.core.cdn.Distribution distribution) throws IOException, BackgroundException {
        URI origin = this.getOrigin(container, distribution.getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Update %s distribution with origin %s", distribution.getMethod().toString(), origin));
        }
        AmazonCloudFront client = this.client(container);
        client.deleteStreamingDistribution(new DeleteStreamingDistributionRequest(distribution.getId(), distribution.getEtag()));
    }

    protected OriginProtocolPolicy getPolicy(Distribution.Method method) {
        return OriginProtocolPolicy.MatchViewer;
    }

    private ch.cyberduck.core.cdn.Distribution readStreamingDistribution(AmazonCloudFront client, StreamingDistributionSummary summary, Path container, Distribution.Method method) throws BackgroundException {
        try {
            GetStreamingDistributionConfigResult response = client.getStreamingDistributionConfig(new GetStreamingDistributionConfigRequest(summary.getId()));
            StreamingDistributionConfig configuration = response.getStreamingDistributionConfig();
            ch.cyberduck.core.cdn.Distribution distribution = new ch.cyberduck.core.cdn.Distribution(this.getOrigin(container, method), method, summary.isEnabled().booleanValue());
            distribution.setId(summary.getId());
            distribution.setDeployed("Deployed".equals(summary.getStatus()));
            distribution.setUrl(URI.create(String.format("%s://%s%s", method.getScheme(), summary.getDomainName(), method.getContext())));
            distribution.setSslUrl(method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) ? URI.create(String.format("https://%s%s", summary.getDomainName(), method.getContext())) : null);
            distribution.setReference(configuration.getCallerReference());
            distribution.setEtag(response.getETag());
            distribution.setStatus(LocaleFactory.localizedString((String)summary.getStatus(), (String)"S3"));
            distribution.setCNAMEs(configuration.getAliases().getItems().toArray(new String[configuration.getAliases().getItems().size()]));
            distribution.setLogging(configuration.getLogging().isEnabled().booleanValue());
            distribution.setLoggingContainer(StringUtils.isNotBlank((CharSequence)configuration.getLogging().getBucket()) ? ServiceUtils.findBucketNameInHostname((String)configuration.getLogging().getBucket(), (String)new S3Protocol().getDefaultHostname()) : null);
            if (this.getFeature(Purge.class, method) != null) {
                distribution.setInvalidationStatus(this.readInvalidationStatus(client, distribution));
            }
            if (this.getFeature(DistributionLogging.class, method) != null) {
                try {
                    distribution.setContainers(new S3BucketListService(this.session).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
                }
                catch (AccessDeniedException | InteroperabilityException e) {
                    log.warn((Object)String.format("Failure listing buckets. %s", e.getMessage()));
                }
            }
            return distribution;
        }
        catch (AmazonClientException e) {
            throw new AmazonServiceExceptionMappingService().map("Cannot read CDN configuration", e);
        }
    }

    private ch.cyberduck.core.cdn.Distribution readDownloadDistribution(AmazonCloudFront client, DistributionSummary summary, Path container, Distribution.Method method) throws BackgroundException {
        try {
            GetDistributionConfigResult response = client.getDistributionConfig(new GetDistributionConfigRequest(summary.getId()));
            DistributionConfig configuration = response.getDistributionConfig();
            ch.cyberduck.core.cdn.Distribution distribution = new ch.cyberduck.core.cdn.Distribution(this.getOrigin(container, method), method, summary.isEnabled().booleanValue());
            distribution.setId(summary.getId());
            distribution.setDeployed("Deployed".equals(summary.getStatus()));
            distribution.setUrl(URI.create(String.format("%s://%s%s", method.getScheme(), summary.getDomainName(), method.getContext())));
            distribution.setSslUrl(method.equals(ch.cyberduck.core.cdn.Distribution.DOWNLOAD) || method.equals(ch.cyberduck.core.cdn.Distribution.CUSTOM) ? URI.create(String.format("https://%s%s", summary.getDomainName(), method.getContext())) : null);
            distribution.setReference(configuration.getCallerReference());
            distribution.setEtag(response.getETag());
            distribution.setStatus(LocaleFactory.localizedString((String)summary.getStatus(), (String)"S3"));
            distribution.setCNAMEs(configuration.getAliases().getItems().toArray(new String[configuration.getAliases().getItems().size()]));
            distribution.setLogging(configuration.getLogging().isEnabled().booleanValue());
            distribution.setLoggingContainer(StringUtils.isNotBlank((CharSequence)configuration.getLogging().getBucket()) ? ServiceUtils.findBucketNameInHostname((String)configuration.getLogging().getBucket(), (String)new S3Protocol().getDefaultHostname()) : null);
            if (StringUtils.isNotBlank((CharSequence)configuration.getDefaultRootObject())) {
                distribution.setIndexDocument(configuration.getDefaultRootObject());
            }
            if (this.getFeature(Purge.class, method) != null) {
                distribution.setInvalidationStatus(this.readInvalidationStatus(client, distribution));
            }
            if (this.getFeature(DistributionLogging.class, method) != null) {
                distribution.setContainers(new S3BucketListService(this.session).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
            }
            return distribution;
        }
        catch (AmazonClientException e) {
            throw new AmazonServiceExceptionMappingService().map("Cannot read CDN configuration", e);
        }
    }

    private AmazonCloudFront client(Path container) throws BackgroundException {
        return (AmazonCloudFront)((AmazonCloudFrontClientBuilder)((AmazonCloudFrontClientBuilder)((AmazonCloudFrontClientBuilder)AmazonCloudFrontClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(new AWSCredentials(){

            public String getAWSAccessKeyId() {
                return CloudFrontDistributionConfiguration.this.session.getHost().getCredentials().getUsername();
            }

            public String getAWSSecretKey() {
                return CloudFrontDistributionConfiguration.this.session.getHost().getCredentials().getPassword();
            }
        }))).withClientConfiguration(this.configuration)).withRegion(this.locationFeature.getLocation(container).getIdentifier())).build();
    }

    private static interface Authenticated<T>
    extends Callable<T> {
        @Override
        public T call() throws BackgroundException;
    }
}

