/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.iam;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.iam.AmazonServiceExceptionMappingService;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.amazonaws.services.identitymanagement.model.AccessKeyMetadata;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.CreateAccessKeyResult;
import com.amazonaws.services.identitymanagement.model.CreateUserRequest;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.DeleteUserRequest;
import com.amazonaws.services.identitymanagement.model.EntityAlreadyExistsException;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest;
import com.amazonaws.services.identitymanagement.model.ListAccessKeysResult;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListUserPoliciesResult;
import com.amazonaws.services.identitymanagement.model.NoSuchEntityException;
import com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest;
import com.amazonaws.services.identitymanagement.model.User;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class AmazonIdentityConfiguration
implements IdentityConfiguration {
    private static final Logger log = Logger.getLogger(AmazonIdentityConfiguration.class);
    private final Host host;
    private static final String prefix = "iam.";
    public final ClientConfiguration configuration;

    public AmazonIdentityConfiguration(Host host) {
        this(host, PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000);
    }

    public AmazonIdentityConfiguration(Host host, int timeout) {
        this.host = host;
        this.configuration = new ClientConfiguration();
        this.configuration.setConnectionTimeout(timeout);
        this.configuration.setSocketTimeout(timeout);
        PreferencesUseragentProvider ua = new PreferencesUseragentProvider();
        this.configuration.setUserAgentPrefix(ua.get());
        this.configuration.setMaxErrorRetry(0);
        this.configuration.setMaxConnections(1);
        this.configuration.setUseGzip(PreferencesFactory.get().getBoolean("http.compression.enable"));
        Proxy proxy = ProxyFactory.get().find(host);
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                this.configuration.setProxyHost(proxy.getHostname());
                this.configuration.setProxyPort(proxy.getPort());
            }
        }
    }

    private <T> T authenticated(Authenticated<T> run, LoginCallback prompt) throws BackgroundException {
        LoginOptions options = new LoginOptions().anonymous(false).publickey(false);
        try {
            KeychainLoginService login = new KeychainLoginService(prompt, PasswordStoreFactory.get());
            login.validate(this.host, LocaleFactory.localizedString((String)"AWS Identity and Access Management", (String)"S3"), options);
            return run.call();
        }
        catch (LoginFailureException failure) {
            prompt.prompt(this.host, this.host.getCredentials(), LocaleFactory.localizedString((String)"Login failed", (String)"Credentials"), failure.getMessage(), options);
            return this.authenticated(run, prompt);
        }
    }

    public void delete(final String username, LoginCallback prompt) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Delete user %s", username));
        }
        this.authenticated(new Authenticated<Void>(){

            @Override
            public Void call() throws BackgroundException {
                PreferencesFactory.get().deleteProperty(String.format("%s%s", AmazonIdentityConfiguration.prefix, username));
                AmazonIdentityManagement client = (AmazonIdentityManagement)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(new AWSCredentials(){

                    public String getAWSAccessKeyId() {
                        return AmazonIdentityConfiguration.this.host.getCredentials().getUsername();
                    }

                    public String getAWSSecretKey() {
                        return AmazonIdentityConfiguration.this.host.getCredentials().getPassword();
                    }
                }))).withClientConfiguration(AmazonIdentityConfiguration.this.configuration)).build();
                try {
                    ListAccessKeysResult keys = client.listAccessKeys(new ListAccessKeysRequest().withUserName(username));
                    for (AccessKeyMetadata key : keys.getAccessKeyMetadata()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delete access key %s for user %s", key, username));
                        }
                        client.deleteAccessKey(new DeleteAccessKeyRequest(username, key.getAccessKeyId()));
                    }
                    ListUserPoliciesResult policies = client.listUserPolicies(new ListUserPoliciesRequest(username));
                    for (String policy : policies.getPolicyNames()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delete policy %s for user %s", policy, username));
                        }
                        client.deleteUserPolicy(new DeleteUserPolicyRequest(username, policy));
                    }
                    client.deleteUser(new DeleteUserRequest(username));
                }
                catch (NoSuchEntityException e) {
                    log.warn((Object)String.format("User %s already removed", username));
                }
                catch (AmazonClientException e) {
                    throw new AmazonServiceExceptionMappingService().map("Cannot write user configuration", e);
                }
                finally {
                    client.shutdown();
                }
                return null;
            }
        }, prompt);
    }

    public Credentials getCredentials(String username) {
        String key = PreferencesFactory.get().getProperty(String.format("%s%s", prefix, username));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Lookup access key for user %s with %s", username, key));
        }
        if (null == key) {
            log.warn((Object)String.format("No access key found for user %s", username));
            return null;
        }
        return new Credentials(key, PasswordStoreFactory.get().getPassword(this.host.getProtocol().getScheme(), this.host.getPort(), this.host.getHostname(), key));
    }

    public void create(final String username, final String policy, LoginCallback prompt) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Create user %s with policy %s", username, policy));
        }
        this.authenticated(new Authenticated<Void>(){

            @Override
            public Void call() throws BackgroundException {
                AmazonIdentityManagement client = (AmazonIdentityManagement)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(new AWSCredentials(){

                    public String getAWSAccessKeyId() {
                        return AmazonIdentityConfiguration.this.host.getCredentials().getUsername();
                    }

                    public String getAWSSecretKey() {
                        return AmazonIdentityConfiguration.this.host.getCredentials().getPassword();
                    }
                }))).withClientConfiguration(AmazonIdentityConfiguration.this.configuration)).build();
                try {
                    User user;
                    try {
                        user = client.createUser(new CreateUserRequest().withUserName(username)).getUser();
                    }
                    catch (EntityAlreadyExistsException e) {
                        user = client.getUser(new GetUserRequest().withUserName(username)).getUser();
                    }
                    CreateAccessKeyResult key = client.createAccessKey(new CreateAccessKeyRequest().withUserName(user.getUserName()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Created access key %s for user %s", key, username));
                    }
                    client.putUserPolicy(new PutUserPolicyRequest(user.getUserName(), "Policy", policy));
                    String id = key.getAccessKey().getAccessKeyId();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Map user %s to access key %s", String.format("%s%s", AmazonIdentityConfiguration.prefix, username), id));
                    }
                    PreferencesFactory.get().setProperty(String.format("%s%s", AmazonIdentityConfiguration.prefix, username), id);
                    PasswordStoreFactory.get().addPassword(AmazonIdentityConfiguration.this.host.getProtocol().getScheme(), AmazonIdentityConfiguration.this.host.getPort(), AmazonIdentityConfiguration.this.host.getHostname(), id, key.getAccessKey().getSecretAccessKey());
                }
                catch (AmazonClientException e) {
                    throw new AmazonServiceExceptionMappingService().map("Cannot write user configuration", e);
                }
                finally {
                    client.shutdown();
                }
                return null;
            }
        }, prompt);
    }

    private static interface Authenticated<T>
    extends Callable<T> {
        @Override
        public T call() throws BackgroundException;
    }
}

