/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.kms;

import ch.cyberduck.core.KeychainLoginService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.iam.AmazonServiceExceptionMappingService;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.s3.S3EncryptionFeature;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.kms.model.AliasListEntry;
import com.amazonaws.services.kms.model.KeyListEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KMSEncryptionFeature
extends S3EncryptionFeature {
    private static final Logger log = Logger.getLogger(KMSEncryptionFeature.class);
    private final S3Session session;
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final ClientConfiguration configuration;
    private final S3LocationFeature locationFeature;
    public static final Encryption.Algorithm SSE_KMS_DEFAULT = new Encryption.Algorithm("aws:kms", null){

        public String getDescription() {
            return "SSE-KMS";
        }
    };

    public KMSEncryptionFeature(S3Session session) {
        this(session, PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000);
    }

    public KMSEncryptionFeature(S3Session session, int timeout) {
        super(session);
        this.session = session;
        this.configuration = new ClientConfiguration();
        this.configuration.setConnectionTimeout(timeout);
        this.configuration.setSocketTimeout(timeout);
        PreferencesUseragentProvider ua = new PreferencesUseragentProvider();
        this.configuration.setUserAgentPrefix(ua.get());
        this.configuration.setMaxErrorRetry(0);
        this.configuration.setMaxConnections(1);
        this.configuration.setUseGzip(PreferencesFactory.get().getBoolean("http.compression.enable"));
        Proxy proxy = ProxyFactory.get().find(session.getHost());
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                this.configuration.setProxyHost(proxy.getHostname());
                this.configuration.setProxyPort(proxy.getPort());
            }
        }
        this.locationFeature = new S3LocationFeature(session);
    }

    private <T> T authenticated(Authenticated<T> run, LoginCallback prompt) throws BackgroundException {
        LoginOptions options = new LoginOptions().anonymous(false).publickey(false);
        try {
            KeychainLoginService login = new KeychainLoginService(prompt, PasswordStoreFactory.get());
            login.validate(this.session.getHost(), LocaleFactory.localizedString((String)"AWS Key Management Service", (String)"S3"), options);
            return run.call();
        }
        catch (LoginFailureException failure) {
            prompt.prompt(this.session.getHost(), this.session.getHost().getCredentials(), LocaleFactory.localizedString((String)"Login failed", (String)"Credentials"), failure.getMessage(), options);
            return this.authenticated(run, prompt);
        }
    }

    @Override
    public Encryption.Algorithm getDefault(Path file) {
        String setting = this.preferences.getProperty("s3.encryption.algorithm");
        if (StringUtils.equals((CharSequence)KMSEncryptionFeature.SSE_KMS_DEFAULT.algorithm, (CharSequence)setting)) {
            String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
            if (StringUtils.isNotBlank((CharSequence)this.preferences.getProperty(key))) {
                return Encryption.Algorithm.fromString((String)this.preferences.getProperty(key));
            }
            return SSE_KMS_DEFAULT;
        }
        return super.getDefault(file);
    }

    @Override
    public Encryption.Algorithm getEncryption(Path file) throws BackgroundException {
        String key;
        if (this.containerService.isContainer(file) && StringUtils.isNotBlank((CharSequence)this.preferences.getProperty(key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName())))) {
            return Encryption.Algorithm.fromString((String)this.preferences.getProperty(key));
        }
        return super.getEncryption(file);
    }

    @Override
    public void setEncryption(Path file, Encryption.Algorithm setting) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            String key = String.format("s3.encryption.key.%s", this.containerService.getContainer(file).getName());
            this.preferences.setProperty(key, setting.toString());
        }
        super.setEncryption(file, setting);
    }

    @Override
    public Set<Encryption.Algorithm> getKeys(Path file, LoginCallback prompt) throws BackgroundException {
        final Path container = this.containerService.getContainer(file);
        Set<Encryption.Algorithm> keys = super.getKeys(container, prompt);
        if (container.isRoot()) {
            return keys;
        }
        try {
            keys.addAll((Collection<Encryption.Algorithm>)this.authenticated(new Authenticated<Set<Encryption.Algorithm>>(){

                @Override
                public Set<Encryption.Algorithm> call() throws BackgroundException {
                    Location.Name region = KMSEncryptionFeature.this.locationFeature.getLocation(container);
                    AWSKMS client = (AWSKMS)((AWSKMSClientBuilder)((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(new AWSCredentials(){

                        public String getAWSAccessKeyId() {
                            return KMSEncryptionFeature.this.session.getHost().getCredentials().getUsername();
                        }

                        public String getAWSSecretKey() {
                            return KMSEncryptionFeature.this.session.getHost().getCredentials().getPassword();
                        }
                    }))).withClientConfiguration(KMSEncryptionFeature.this.configuration)).withRegion(region.getIdentifier())).build();
                    try {
                        HashMap<String, String> aliases = new HashMap<String, String>();
                        for (AliasListEntry entry : client.listAliases().getAliases()) {
                            aliases.put(entry.getTargetKeyId(), entry.getAliasName());
                        }
                        HashSet<AliasedAlgorithm> keys = new HashSet<AliasedAlgorithm>();
                        for (KeyListEntry entry : client.listKeys().getKeys()) {
                            keys.add(new AliasedAlgorithm(entry, (String)aliases.get(entry.getKeyId()), region));
                        }
                        HashSet<AliasedAlgorithm> hashSet = keys;
                        return hashSet;
                    }
                    catch (AmazonClientException e) {
                        throw new AmazonServiceExceptionMappingService().map("Cannot read AWS KMS configuration", e);
                    }
                    finally {
                        client.shutdown();
                    }
                }
            }, prompt));
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Ignore failure reading keys from KMS. %s", e.getMessage()));
            keys.add(SSE_KMS_DEFAULT);
        }
        return keys;
    }

    private static class AliasedAlgorithm
    extends Encryption.Algorithm {
        private final KeyListEntry entry;
        private final String alias;
        private final Location.Name region;

        public AliasedAlgorithm(KeyListEntry entry, String alias, Location.Name region) {
            super(KMSEncryptionFeature.SSE_KMS_DEFAULT.algorithm, entry.getKeyArn());
            this.entry = entry;
            this.alias = alias;
            this.region = region;
        }

        public String getDescription() {
            if (StringUtils.isBlank((CharSequence)this.alias)) {
                return String.format("SSE-KMS (%s)", this.entry.getKeyArn());
            }
            return String.format("SSE-KMS (%s - %s)", this.alias, this.entry.getKeyArn());
        }

        public Location.Name getRegion() {
            return this.region;
        }
    }

    private static interface Authenticated<T>
    extends Callable<T> {
        @Override
        public T call() throws BackgroundException;
    }
}

