/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class S3BulkTransferAccelerationFeature
implements Bulk<Void> {
    private static final Logger log = Logger.getLogger(S3BulkTransferAccelerationFeature.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final S3Session session;
    private final TransferAcceleration accelerationService;

    public S3BulkTransferAccelerationFeature(S3Session session) {
        this(session, (TransferAcceleration)session.getFeature(TransferAcceleration.class));
    }

    public S3BulkTransferAccelerationFeature(S3Session session, TransferAcceleration accelerationService) {
        this.session = session;
        this.accelerationService = accelerationService;
    }

    public Void pre(Transfer.Type type, Map<Path, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        this.configure(files, callback, true);
        return null;
    }

    public void post(Transfer.Type type, Map<Path, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        this.configure(files, callback, false);
    }

    public Bulk<Void> withDelete(Delete delete) {
        return this;
    }

    private void configure(Map<Path, TransferStatus> files, ConnectionCallback callback, boolean enabled) throws BackgroundException {
        HashSet<Path> buckets = new HashSet<Path>();
        for (Path file : files.keySet()) {
            buckets.add(new S3PathContainerService().getContainer(file));
        }
        for (Path bucket : buckets) {
            if (enabled) {
                try {
                    if (this.accelerate(bucket, callback)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Tunnel upload for file %s through accelerated endpoint %s", bucket, this.accelerationService));
                        }
                        this.accelerationService.configure(true, bucket);
                        continue;
                    }
                    log.warn((Object)String.format("Transfer acceleration disabled for %s", bucket));
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)String.format("Ignore failure reading S3 accelerate configuration. %s", e.getMessage()));
                }
                continue;
            }
            this.accelerationService.configure(false, bucket);
        }
    }

    private boolean accelerate(Path file, ConnectionCallback prompt) throws BackgroundException {
        switch (this.session.getSignatureVersion()) {
            case AWS2: {
                return false;
            }
        }
        if (this.accelerationService.getStatus(file)) {
            log.info((Object)String.format("S3 transfer acceleration enabled for file %s", file));
            return true;
        }
        if (this.preferences.getBoolean("s3.accelerate.prompt") && this.accelerationService.prompt(this.session.getHost(), file, prompt)) {
            log.info((Object)String.format("S3 transfer acceleration enabled for file %s", file));
            return true;
        }
        return false;
    }
}

