/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.StorageObject;

public class S3CopyFeature
implements Copy {
    private static final Logger log = Logger.getLogger(S3CopyFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3AccessControlListFeature accessControlListFeature;

    public S3CopyFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    public void copy(Path source, Path target, TransferStatus status) throws BackgroundException {
        if (source.isFile() || source.isPlaceholder()) {
            String storageClass = source.attributes().getStorageClass();
            Encryption.Algorithm encryption = source.attributes().getEncryption();
            if (null == this.accessControlListFeature) {
                this.copy(source, target, storageClass, encryption, Acl.EMPTY);
            } else {
                Acl acl = Acl.EMPTY;
                try {
                    acl = this.accessControlListFeature.getPermission(source);
                }
                catch (AccessDeniedException | InteroperabilityException e) {
                    log.warn((Object)String.format("Ignore failure %s", e.getDetail()));
                }
                this.copy(source, target, storageClass, encryption, acl);
            }
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }

    protected void copy(Path source, Path copy, String storageClass, Encryption.Algorithm encryption, Acl acl) throws BackgroundException {
        if (source.isFile() || source.isPlaceholder()) {
            StorageObject destination = new StorageObject(this.containerService.getKey(copy));
            destination.setStorageClass(storageClass);
            destination.setServerSideEncryptionAlgorithm(encryption.algorithm);
            destination.setServerSideEncryptionKmsKeyId(encryption.key);
            if (null == this.accessControlListFeature) {
                destination.setAcl(null);
            } else {
                destination.setAcl(this.accessControlListFeature.convert(acl));
            }
            try {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).copyObject(this.containerService.getContainer(source).getName(), this.containerService.getKey(source), this.containerService.getContainer(copy).getName(), destination, false);
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
            }
        }
    }
}

