/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3BucketCreateService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.model.StorageObject;

public class S3DirectoryFeature
implements Directory<StorageObject> {
    private static final String MIMETYPE = "application/x-directory";
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private Write<StorageObject> writer;

    public S3DirectoryFeature(S3Session session, Write<StorageObject> writer) {
        this.session = session;
        this.writer = writer;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        if (this.containerService.isContainer(folder)) {
            S3BucketCreateService service = new S3BucketCreateService(this.session);
            service.create(folder, StringUtils.isBlank((CharSequence)region) ? PreferencesFactory.get().getProperty("s3.location") : region);
        } else {
            Redundancy redundancy;
            Encryption encryption;
            if (null == status.getEncryption() && (encryption = (Encryption)this.session.getFeature(Encryption.class)) != null) {
                status.setEncryption(encryption.getDefault(folder));
            }
            if (null == status.getStorageClass() && (redundancy = (Redundancy)this.session.getFeature(Redundancy.class)) != null) {
                status.setStorageClass(redundancy.getDefault());
            }
            if (Checksum.NONE == status.getChecksum()) {
                status.setChecksum(this.writer.checksum().compute((InputStream)new NullInputStream(0L), status.length(0L)));
            }
            status.setMime(MIMETYPE);
            folder.getType().add(AbstractPath.Type.placeholder);
            new DefaultStreamCloser().close((OutputStream)this.writer.write(folder, status, (ConnectionCallback)new DisabledConnectionCallback()));
        }
        return folder;
    }

    public boolean isSupported(Path workdir) {
        return true;
    }

    public S3DirectoryFeature withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

