/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.jets3t.service.ServiceException;
import org.xml.sax.SAXException;

public class S3ExceptionMappingService
extends AbstractExceptionMappingService<ServiceException> {
    public BackgroundException map(ServiceException e) {
        if (e.getCause() instanceof ServiceException) {
            return this.map((ServiceException)e.getCause());
        }
        StringBuilder buffer = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)e.getErrorMessage())) {
            this.append(buffer, StringEscapeUtils.unescapeXml((String)e.getErrorMessage()));
        } else {
            this.append(buffer, e.getResponseStatus());
            this.append(buffer, e.getMessage());
        }
        switch (e.getResponseCode()) {
            case 403: {
                if (StringUtils.isNotBlank((CharSequence)e.getErrorCode())) {
                    switch (e.getErrorCode()) {
                        case "SignatureDoesNotMatch": 
                        case "InvalidAccessKeyId": 
                        case "InvalidClientTokenId": 
                        case "InvalidSecurity": 
                        case "MissingClientTokenId": 
                        case "MissingAuthenticationToken": {
                            return new LoginFailureException(buffer.toString(), (Throwable)e);
                        }
                    }
                }
            }
            case 400: {
                if (!StringUtils.isNotBlank((CharSequence)e.getErrorCode())) break;
                switch (e.getErrorCode()) {
                    case "RequestTimeout": {
                        return new ConnectionTimeoutException(buffer.toString(), (Throwable)e);
                    }
                }
            }
        }
        if (e.getCause() instanceof IOException) {
            return new DefaultIOExceptionMappingService().map((IOException)e.getCause());
        }
        if (e.getCause() instanceof SAXException) {
            return new InteroperabilityException(buffer.toString(), (Throwable)e);
        }
        return new HttpResponseExceptionMappingService().map(new HttpResponseException(e.getResponseCode(), buffer.toString()));
    }
}

