/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;

public class S3FindFeature
implements Find {
    private static final Logger log = Logger.getLogger(S3AttributesFinderFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private Cache<Path> cache;

    public S3FindFeature(S3Session session) {
        this.session = session;
        this.cache = PathCache.empty();
    }

    public boolean find(Path file) throws BackgroundException {
        AttributedList list;
        if (file.isRoot()) {
            return true;
        }
        if (this.cache.isCached((Referenceable)file.getParent())) {
            list = this.cache.get((Referenceable)file.getParent());
        } else {
            list = new AttributedList();
            this.cache.put((Referenceable)file.getParent(), list);
        }
        if (list.contains((Referenceable)file)) {
            return true;
        }
        if (this.cache.isHidden((Referenceable)file)) {
            return false;
        }
        try {
            if (((RequestEntityRestStorageService)((Object)this.session.getClient())).isObjectInBucket(this.containerService.getContainer(file).getName(), this.containerService.getKey(file))) {
                list.add((Referenceable)file);
                return true;
            }
            list.attributes().addHidden((Object)file);
            return false;
        }
        catch (ServiceException e) {
            switch (this.session.getSignatureVersion()) {
                case AWS4HMACSHA256: {
                    if (!(new S3ExceptionMappingService().map(e) instanceof InteroperabilityException)) break;
                    log.warn((Object)"Workaround HEAD failure using GET because the expected AWS region cannot be determined from the HEAD error message if using AWS4-HMAC-SHA256 with the wrong region specifier in the authentication header.");
                    try {
                        S3Object object = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getObject(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), null, null, null, null, null, null);
                        IOUtils.closeQuietly((InputStream)object.getDataInputStream());
                        list.add((Referenceable)file);
                        return true;
                    }
                    catch (ServiceException f) {
                        if (new S3ExceptionMappingService().map(f) instanceof NotfoundException) {
                            list.attributes().addHidden((Object)file);
                            return false;
                        }
                        if (f.getResponseCode() != 416) break;
                        return true;
                    }
                }
            }
            throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

