/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.StorageObject;

public class S3MoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(S3MoveFeature.class);
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final S3AccessControlListFeature accessControlListFeature;
    private Delete delete;

    public S3MoveFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
        this.delete = new S3DefaultDeleteFeature(session);
    }

    public void move(Path source, Path renamed, boolean exists, Delete.Callback callback) throws BackgroundException {
        block8: {
            try {
                Encryption encryptionFeature;
                if (!source.isFile() && !source.isPlaceholder()) break block8;
                StorageObject destination = new StorageObject(this.containerService.getKey(renamed));
                Redundancy storageClassFeature = (Redundancy)this.session.getFeature(Redundancy.class);
                if (storageClassFeature != null) {
                    destination.setStorageClass(storageClassFeature.getClass(source));
                }
                if ((encryptionFeature = (Encryption)this.session.getFeature(Encryption.class)) != null) {
                    Encryption.Algorithm encryption = encryptionFeature.getEncryption(source);
                    destination.setServerSideEncryptionAlgorithm(encryption.algorithm);
                    destination.setServerSideEncryptionKmsKeyId(encryption.key);
                }
                if (this.accessControlListFeature != null) {
                    Acl acl = Acl.EMPTY;
                    try {
                        acl = this.accessControlListFeature.getPermission(source);
                    }
                    catch (AccessDeniedException | InteroperabilityException e) {
                        log.warn((Object)String.format("Ignore failure %s", e.getDetail()));
                    }
                    destination.setAcl(this.accessControlListFeature.convert(acl));
                }
                Map headers = ((RequestEntityRestStorageService)((Object)this.session.getClient())).copyObject(this.containerService.getContainer(source).getName(), this.containerService.getKey(source), this.containerService.getContainer(renamed).getName(), destination, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received response headers for copy %s", headers));
                }
                this.delete.delete(Collections.singletonList(source), (LoginCallback)new DisabledLoginCallback(), (Delete.Callback)new Delete.DisabledCallback());
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot rename {0}", e, source);
            }
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

