/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.ThreadPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;

public class S3MultipartCopyFeature
extends S3CopyFeature {
    private static final Logger log = Logger.getLogger(S3MultipartCopyFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final ThreadPool pool = new DefaultThreadPool("multipart", PreferencesFactory.get().getInteger("s3.upload.multipart.concurrency"));
    private final Long partsize = PreferencesFactory.get().getLong("s3.upload.multipart.size");
    private final S3AccessControlListFeature accessControlListFeature;

    public S3MultipartCopyFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        super(session, accessControlListFeature);
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    @Override
    protected void copy(Path source, Path copy, String storageClass, Encryption.Algorithm encryption, Acl acl) throws BackgroundException {
        if (source.isFile() || source.isPlaceholder()) {
            S3Object destination = new S3Object(this.containerService.getKey(copy));
            destination.setStorageClass(storageClass);
            destination.setServerSideEncryptionAlgorithm(encryption.algorithm);
            destination.setServerSideEncryptionKmsKeyId(encryption.key);
            if (null != this.accessControlListFeature) {
                destination.setAcl(this.accessControlListFeature.convert(acl));
            }
            try {
                long size;
                ArrayList completed = new ArrayList();
                MultipartUpload multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(this.containerService.getContainer(copy).getName(), destination);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
                }
                long remaining = size = source.attributes().getSize();
                long offset = 0L;
                ArrayList<Future<MultipartPart>> parts = new ArrayList<Future<MultipartPart>>();
                int partNumber = 1;
                while (remaining > 0L) {
                    Long l = Math.min(Math.max(size / 10000L, this.partsize), remaining);
                    parts.add(this.submit(source, multipart, partNumber, offset, l));
                    remaining -= l.longValue();
                    offset += l.longValue();
                    ++partNumber;
                }
                for (Future future : parts) {
                    try {
                        completed.add(future.get());
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Part upload failed with interrupt failure");
                        throw new ConnectionCanceledException((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
                        if (e.getCause() instanceof BackgroundException) {
                            throw (BackgroundException)e.getCause();
                        }
                        throw new BackgroundException(e.getCause());
                    }
                }
                MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartCompleteUpload(multipart, completed);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Completed multipart upload for %s with checksum %s", complete.getObjectKey(), complete.getEtag()));
                }
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
            }
            finally {
                this.pool.shutdown(false);
            }
        }
    }

    private Future<MultipartPart> submit(final Path source, final MultipartUpload multipart, final int partNumber, final long offset, final long length) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, source, offset, length));
        }
        return this.pool.execute((Callable)new Callable<MultipartPart>(){

            @Override
            public MultipartPart call() throws BackgroundException {
                try {
                    HttpRange range = HttpRange.byLength((long)offset, (long)length);
                    MultipartPart part = ((RequestEntityRestStorageService)((Object)S3MultipartCopyFeature.this.session.getClient())).multipartUploadPartCopy(multipart, partNumber, S3MultipartCopyFeature.this.containerService.getContainer(source).getName(), S3MultipartCopyFeature.this.containerService.getKey(source), null, null, null, null, range.getStart(), range.getEnd(), source.attributes().getVersionId());
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Received response %s for part number %d", part, partNumber));
                    }
                    return new MultipartPart(Integer.valueOf(partNumber), null == part.getLastModified() ? new Date(System.currentTimeMillis()) : part.getLastModified(), null == part.getEtag() ? "" : part.getEtag(), part.getSize());
                }
                catch (S3ServiceException e) {
                    throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
                }
            }
        });
    }
}

