/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Version;
import org.jets3t.service.model.StorageObject;

public class S3ObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3ObjectListService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3AttributesFinderFeature attributes;

    public S3ObjectListService(S3Session session) {
        this.session = session;
        this.attributes = new S3AttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            String prefix = this.createPrefix(directory);
            AttributedList objects = new AttributedList();
            objects.addAll(this.listObjects(directory, prefix, listener));
            Versioning feature = (Versioning)this.session.getFeature(Versioning.class);
            Path container = this.containerService.getContainer(directory);
            if (feature != null && feature.getConfiguration(container).isEnabled()) {
                String priorLastKey = null;
                String priorLastVersionId = null;
                do {
                    VersionOrDeleteMarkersChunk chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(container.getName(), prefix, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, true);
                    objects.addAll(this.listVersions(container, directory, Arrays.asList(chunk.getItems())));
                    priorLastKey = chunk.getNextKeyMarker();
                    priorLastVersionId = chunk.getNextVersionIdMarker();
                    listener.chunk(directory, objects);
                } while (priorLastKey != null);
            }
            return objects;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, directory);
        }
    }

    protected String createPrefix(Path directory) {
        String prefix = "";
        if (!this.containerService.isContainer(directory) && !(prefix = this.containerService.getKey(directory)).endsWith(String.valueOf('/'))) {
            prefix = prefix + '/';
        }
        return prefix;
    }

    protected AttributedList<Path> listObjects(Path parent, String prefix, ListProgressListener listener) throws IOException, ServiceException, BackgroundException {
        Path bucket = this.containerService.getContainer(parent);
        AttributedList children = new AttributedList();
        String priorLastKey = null;
        do {
            String[] prefixes;
            Path file;
            StorageObject[] objects;
            StorageObjectsChunk chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listObjectsChunked(PathNormalizer.name((String)URIEncoder.encode((String)bucket.getName())), prefix, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"), priorLastKey);
            for (StorageObject object : objects = chunk.getObjects()) {
                String key = PathNormalizer.normalize((String)object.getKey());
                if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)parent)) continue;
                EnumSet<AbstractPath.Type> types = object.isDirectoryPlaceholder() ? EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder) : EnumSet.of(AbstractPath.Type.file);
                file = new Path(parent, PathNormalizer.name((String)key), types, this.attributes.convert(object));
                file.attributes().setRegion(bucket.attributes().getRegion());
                children.add((Referenceable)file);
            }
            for (String common : prefixes = chunk.getCommonPrefixes()) {
                if (common.equals(String.valueOf('/'))) {
                    log.warn((Object)String.format("Skipping prefix %s", common));
                    continue;
                }
                String key = PathNormalizer.normalize((String)common);
                if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)parent)) continue;
                file = new Path(parent, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder));
                file.attributes().setRegion(bucket.attributes().getRegion());
                children.add((Referenceable)file);
            }
            priorLastKey = chunk.getPriorLastKey();
            listener.chunk(parent, children);
        } while (priorLastKey != null);
        return children;
    }

    private List<Path> listVersions(Path bucket, Path parent, List<BaseVersionOrDeleteMarker> versionOrDeleteMarkers) throws IOException, ServiceException {
        Collections.sort(versionOrDeleteMarkers, new Comparator<BaseVersionOrDeleteMarker>(){

            @Override
            public int compare(BaseVersionOrDeleteMarker o1, BaseVersionOrDeleteMarker o2) {
                return o1.getLastModified().compareTo(o2.getLastModified());
            }
        });
        ArrayList<Path> versions = new ArrayList<Path>();
        int i = 0;
        for (BaseVersionOrDeleteMarker marker : versionOrDeleteMarkers) {
            String key;
            if ((!marker.isDeleteMarker() || !marker.isLatest()) && marker.isLatest() || new Path(bucket, key = PathNormalizer.normalize((String)marker.getKey()), EnumSet.of(AbstractPath.Type.directory)).equals((Object)parent)) continue;
            Path p = new Path(parent, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.file));
            p.attributes().setVersionId(marker.getVersionId());
            p.attributes().setRevision((long)(++i));
            p.attributes().setDuplicate(true);
            p.attributes().setModificationDate(marker.getLastModified().getTime());
            p.attributes().setRegion(bucket.attributes().getRegion());
            if (marker instanceof S3Version) {
                p.attributes().setSize(((S3Version)marker).getSize());
                p.attributes().setETag(((S3Version)marker).getEtag());
                p.attributes().setStorageClass(((S3Version)marker).getStorageClass());
            }
            versions.add(p);
        }
        return versions;
    }
}

